/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.svm;

import edu.stanford.cs.exp.Expression;
import java.util.ArrayList;

public class SVMModule {
    private ArrayList<String> imports;
    private ArrayList<Expression> functions;
    private ArrayList<Expression> globals;
    private String pathname;
    private String source;

    public SVMModule(String pathname) {
        this.pathname = pathname;
        this.imports = new ArrayList();
        this.functions = new ArrayList();
        this.globals = new ArrayList();
    }

    public String getFilePath() {
        return this.pathname;
    }

    public void addImport(String pathname) {
        this.imports.add(pathname);
    }

    public String getMainFunction() {
        if (this.hasFunction("main")) {
            return "main";
        }
        for (Expression fn : this.functions) {
            String name = fn.getArgs()[0].getName();
            if (name.indexOf("#") != -1 || fn.getArgs()[1].getArgs().length != 0) continue;
            return name;
        }
        return null;
    }

    public boolean hasImport(String name) {
        return this.imports.contains(name);
    }

    public boolean hasFunction(String name) {
        for (Expression fn : this.functions) {
            if (!fn.getArgs()[0].getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<String> getImports() {
        return this.imports;
    }

    public void addFunction(Expression fn) {
        this.functions.add(fn);
    }

    public ArrayList<Expression> getFunctions() {
        return this.functions;
    }

    public void addGlobal(Expression global) {
        this.globals.add(global);
    }

    public ArrayList<Expression> getGlobals() {
        return this.globals;
    }

    public void setSourceText(String source) {
        this.source = source;
    }

    public String getSourceText() {
        return this.source;
    }
}

