/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.svmtools;

import edu.stanford.cs.programeditor.CommentHighlightMode;
import edu.stanford.cs.programeditor.ProgramEditor;
import edu.stanford.cs.tokenscanner.TokenScanner;
import java.awt.Font;
import java.util.TreeMap;
import java.util.TreeSet;

public class SVMEditor
extends ProgramEditor {
    public static final int[] FONT_SIZES = new int[]{7, 8, 9, 10, 11, 12, 14, 16, 18, 20, 24, 28, 32, 36, 40, 44, 48};
    private TreeMap<Integer, Integer> offsetToLine;
    private TreeSet<Integer> breakpointLines;
    private TokenScanner scanner = new TokenScanner();

    public SVMEditor() {
        this.scanner.ignoreWhitespace();
        this.scanner.ignoreComments();
        this.scanner.scanNumbers();
        this.setLineWrap(false);
        this.setEditorMode(new CommentHighlightMode());
        this.offsetToLine = new TreeMap();
        this.breakpointLines = new TreeSet();
    }

    public int getSourceLineIndex(int offset) {
        Integer k = this.offsetToLine.get(offset);
        return k == null ? -1 : k;
    }

    public void clearOffsetTable() {
        this.offsetToLine.clear();
        this.breakpointLines.clear();
    }

    public void addBreakpointLines(int[] code) {
        int n = code.length;
        int i = 0;
        while (i < n) {
            int ins = code[i];
            if (ins >> 24 == 3) {
                int offset = ins & 0xFFFFFF;
                int line = this.getLineNumber(offset);
                this.offsetToLine.put(offset, line);
                this.breakpointLines.add(line);
            }
            ++i;
        }
    }

    public void addWordCharacters(String chars) {
        this.scanner.addWordCharacters(chars);
    }

    public static Font smallerFont(Font font) {
        int nSizes = FONT_SIZES.length;
        int oldSize = font.getSize();
        int newSize = FONT_SIZES[0];
        int i = nSizes - 1;
        while (i >= 0) {
            if (FONT_SIZES[i] < oldSize) {
                newSize = FONT_SIZES[i];
                break;
            }
            --i;
        }
        return font.deriveFont(font.getStyle(), newSize);
    }

    public static Font largerFont(Font font) {
        int nSizes = FONT_SIZES.length;
        int oldSize = font.getSize();
        int newSize = FONT_SIZES[nSizes - 1];
        int i = 0;
        while (i < nSizes) {
            if (FONT_SIZES[i] > oldSize) {
                newSize = FONT_SIZES[i];
                break;
            }
            ++i;
        }
        return font.deriveFont(font.getStyle(), newSize);
    }

    @Override
    public boolean isBreakpointLegal(int k) {
        return this.breakpointLines.contains(k);
    }
}

