/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.utf8;

import java.io.UnsupportedEncodingException;

public class UTF8 {
    public static int[] encode(String str) {
        try {
            byte[] bytes = str.getBytes("UTF-8");
            int n = bytes.length;
            int w = (n + 4) / 4;
            int[] array = new int[w];
            int shift = 24;
            int offset = 0;
            int i = 0;
            while (i < n) {
                int n2 = offset++;
                array[n2] = array[n2] | (bytes[i] & 0xFF) << shift;
                if ((shift -= 8) < 0) {
                    shift = 24;
                }
                ++i;
            }
            return array;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public static String decode(int[] array) {
        return UTF8.decode(array, 0);
    }

    public static String decode(int[] array, int offset) {
        int n = UTF8.getByteLength(array, offset);
        byte[] bytes = new byte[n];
        int shift = 24;
        int i = 0;
        while (i < n) {
            bytes[i] = (byte)(array[offset] >> shift & 0xFF);
            if ((shift -= 8) < 0) {
                shift = 24;
                ++offset;
            }
            ++i;
        }
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    private static int getByteLength(int[] array, int offset) {
        int shift = 24;
        int i = 0;
        while ((array[offset] >> shift & 0xFF) != 0) {
            if ((shift -= 8) < 0) {
                shift = 24;
                ++offset;
            }
            ++i;
        }
        return i;
    }
}

