/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.TreeSet;

public class FileLib {
    public static String getHead(String path) {
        int slashIndex = -1;
        int i = 0;
        while (i < path.length()) {
            if (path.charAt(i) == '/' || path.charAt(i) == '\\') {
                slashIndex = i;
            }
            ++i;
        }
        if (slashIndex == -1) {
            return "";
        }
        if (slashIndex == 0) {
            return path.substring(0, 1);
        }
        return path.substring(0, slashIndex);
    }

    public static String getTail(String path) {
        int slashIndex = -1;
        int i = 0;
        while (i < path.length()) {
            if (path.charAt(i) == '/' || path.charAt(i) == '\\') {
                slashIndex = i;
            }
            ++i;
        }
        if (slashIndex == -1) {
            return path;
        }
        return path.substring(slashIndex + 1);
    }

    public static String getRoot(String path) {
        int dotIndex = -1;
        int i = 0;
        while (i < path.length()) {
            switch (path.charAt(i)) {
                case '.': {
                    dotIndex = i;
                    break;
                }
                case '/': 
                case '\\': {
                    dotIndex = -1;
                }
            }
            ++i;
        }
        if (dotIndex == -1) {
            return path;
        }
        return path.substring(0, dotIndex);
    }

    public static String getExtension(String path) {
        int dotIndex = -1;
        int i = 0;
        while (i < path.length()) {
            switch (path.charAt(i)) {
                case '.': {
                    dotIndex = i;
                    break;
                }
                case '/': 
                case '\\': {
                    dotIndex = -1;
                }
            }
            ++i;
        }
        if (dotIndex == -1) {
            return "";
        }
        return path.substring(dotIndex);
    }

    public static void createDirectory(String path) {
        new File(path).mkdir();
    }

    public static void createDirectoryPath(String path) {
        new File(path).mkdirs();
    }

    public static String defaultExtension(String filename, String ext) {
        boolean force = ext.startsWith("*");
        if (force) {
            ext = ext.substring(1);
        }
        int dot = -1;
        int len = filename.length();
        int i = 0;
        while (i < len) {
            char ch = filename.charAt(i);
            if (ch == '.') {
                dot = i;
            }
            if (ch == '/' || ch == '\\') {
                dot = -1;
            }
            ++i;
        }
        if (dot == -1) {
            force = true;
            dot = len;
        }
        if (force) {
            return String.valueOf(filename.substring(0, dot)) + ext;
        }
        return filename;
    }

    public static void deleteFile(String path) {
        new File(path).delete();
    }

    public static String expandPathname(String path) {
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    public static boolean fileExists(String path) {
        return new File(path).exists();
    }

    public static BufferedReader openOnPath(String path, String filename) {
        String[] stringArray = FileLib.splitPath(path);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            String pathname = String.valueOf(dir) + "/" + filename;
            try {
                return new BufferedReader(new FileReader(pathname));
            }
            catch (IOException iOException) {
                ++n2;
            }
        }
        return null;
    }

    public static String findOnPath(String path, String filename) {
        String[] stringArray = FileLib.splitPath(path);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            String pathname = String.valueOf(dir) + "/" + filename;
            if (new File(pathname).exists()) {
                return pathname;
            }
            ++n2;
        }
        return null;
    }

    public static String getCurrentDirectory() {
        return System.getProperty("user.dir");
    }

    public String getDirectoryPathSeparator() {
        return File.separator;
    }

    public static String getSearchPathSeparator() {
        return File.pathSeparator;
    }

    public boolean isDirectory(String path) {
        return new File(path).isDirectory();
    }

    public static boolean isFile(String path) {
        return new File(path).isFile();
    }

    public static String[] listDirectory(String path) {
        String[] list = new File(path).list();
        if (list == null) {
            return null;
        }
        TreeSet<String> tree = new TreeSet<String>();
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (!name.equals(".") && !name.equals("..")) {
                tree.add(name);
            }
            ++n2;
        }
        return tree.toArray(new String[tree.size()]);
    }

    public static BufferedReader openReader(String path) {
        try {
            return new BufferedReader(new FileReader(path));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    public static PrintWriter openWriter(String path) {
        try {
            return new PrintWriter(new BufferedWriter(new FileWriter(path)));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    private static String[] splitPath(String path) {
        int finish;
        ArrayList<String> list = new ArrayList<String>();
        String sep = path.contains(";") ? ";" : ":";
        path = String.valueOf(path) + sep;
        int start = 0;
        while ((finish = path.indexOf(sep, start)) != -1) {
            if (finish > start) {
                list.add(path.substring(start, finish));
            }
            start = finish + 1;
        }
        return list.toArray(new String[list.size()]);
    }
}

