/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.graphics;

import edu.stanford.cs.graphics.GFillable;
import edu.stanford.cs.graphics.GMath;
import edu.stanford.cs.graphics.GObject;
import edu.stanford.cs.graphics.GPoint;
import edu.stanford.cs.graphics.GRectangle;
import edu.stanford.cs.graphics.GTransform;
import edu.stanford.cs.graphics.VertexList;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;

public class GPolygon
extends GObject
implements GFillable {
    private VertexList vertices = new VertexList();
    private boolean isFilled;
    private Color fillColor;

    public GPolygon() {
        this.clear();
    }

    public GPolygon(double x, double y) {
        this();
        this.setLocation(x, y);
    }

    public GPolygon(GPoint[] points) {
        this();
        this.vertices.add(points);
    }

    public void addVertex(double x, double y) {
        this.vertices.addVertex(x, y);
    }

    public void addEdge(double dx, double dy) {
        this.vertices.addEdge(dx, dy);
    }

    public final void addPolarEdge(double r, double theta) {
        this.vertices.addEdge(r * GMath.cosDegrees(theta), -r * GMath.sinDegrees(theta));
    }

    public void addArc(double arcWidth, double arcHeight, double start, double sweep) {
        this.vertices.addArc(arcWidth, arcHeight, start, sweep);
    }

    public GPoint getCurrentPoint() {
        return this.vertices.getCurrentPoint();
    }

    @Override
    public void setFilled(boolean fill) {
        this.isFilled = fill;
        this.repaint();
    }

    @Override
    public boolean isFilled() {
        return this.isFilled;
    }

    @Override
    public void setFillColor(Color color) {
        this.fillColor = color;
        this.repaint();
    }

    @Override
    public Color getFillColor() {
        return this.fillColor == null ? this.getColor() : this.fillColor;
    }

    @Override
    protected GRectangle localBounds(GTransform ctm) {
        int nPoints = this.vertices.size();
        if (nPoints == 0) {
            return new GRectangle();
        }
        GRectangle bb = new GRectangle(ctm.transform(this.vertices.get(0)));
        int i = 1;
        while (i < nPoints) {
            bb.add(ctm.transform(this.vertices.get(i)));
            ++i;
        }
        return bb;
    }

    @Override
    protected boolean localContains(double x, double y) {
        int nPoints = this.vertices.size();
        boolean isContained = false;
        int i = 0;
        while (i < nPoints) {
            GPoint v1 = this.vertices.get(i);
            GPoint v2 = this.vertices.get((i + 1) % nPoints);
            if (v1.getY() < y && v2.getY() >= y || v2.getY() < y && v1.getY() >= y) {
                double t = (y - v1.getY()) / (v2.getY() - v1.getY());
                double xp = v1.getX() + t * (v2.getX() - v1.getX());
                if (xp < x) {
                    isContained = !isContained;
                }
            }
            ++i;
        }
        return isContained;
    }

    @Override
    protected void paint2d(Graphics2D g) {
        int nPoints = this.vertices.size();
        Path2D.Double path = new Path2D.Double(0);
        ((Path2D)path).moveTo(this.vertices.get(0).getX(), this.vertices.get(0).getY());
        int i = 0;
        while (i < nPoints) {
            ((Path2D)path).lineTo(this.vertices.get(i).getX(), this.vertices.get(i).getY());
            ++i;
        }
        ((Path2D)path).lineTo(this.vertices.get(0).getX(), this.vertices.get(0).getY());
        if (this.isFilled()) {
            g.setColor(this.getFillColor());
            g.fill(path);
            g.setColor(this.getColor());
        }
        g.draw(path);
    }

    @Override
    public Object clone() {
        try {
            GPolygon clone = (GPolygon)super.clone();
            clone.vertices = new VertexList(clone.vertices);
            return clone;
        }
        catch (Exception CloneNotSupportedException) {
            throw new RuntimeException("Impossible exception");
        }
    }

    protected void clear() {
        this.vertices.clear();
    }
}

