/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.graphics;

import edu.stanford.cs.graphics.GDimension;
import edu.stanford.cs.graphics.GFillable;
import edu.stanford.cs.graphics.GObject;
import edu.stanford.cs.graphics.GRectangle;
import edu.stanford.cs.graphics.GResizable;
import edu.stanford.cs.graphics.GTransform;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class GRect
extends GObject
implements GFillable,
GResizable {
    private double width;
    private double height;
    private boolean isFilled;
    private Color fillColor;

    public GRect(double width, double height) {
        this(0.0, 0.0, width, height);
    }

    public GRect(double x, double y, double width, double height) {
        this.width = width;
        this.height = height;
        this.setLocation(x, y);
    }

    @Override
    public void setFilled(boolean fill) {
        this.isFilled = fill;
        this.repaint();
    }

    @Override
    public boolean isFilled() {
        return this.isFilled;
    }

    @Override
    public void setFillColor(Color color) {
        this.fillColor = color;
        this.repaint();
    }

    @Override
    public Color getFillColor() {
        return this.fillColor == null ? this.getColor() : this.fillColor;
    }

    @Override
    public void setSize(double width, double height) {
        if (this.isTransformed()) {
            throw new RuntimeException("setSize called on transformed object");
        }
        this.width = width;
        this.height = height;
        this.repaint();
    }

    @Override
    public final void setSize(GDimension size) {
        this.setSize(size.getWidth(), size.getHeight());
    }

    @Override
    public void setBounds(double x, double y, double width, double height) {
        if (this.isTransformed()) {
            throw new RuntimeException("setBounds called on transformed object");
        }
        this.width = width;
        this.height = height;
        this.setLocation(x, y);
    }

    @Override
    public final void setBounds(GRectangle bounds) {
        this.setBounds(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    @Override
    protected GRectangle localBounds(GTransform ctm) {
        GRectangle bb = new GRectangle(ctm.transform(0.0, 0.0));
        bb.add(ctm.transform(this.width, 0.0));
        bb.add(ctm.transform(0.0, this.height));
        bb.add(ctm.transform(this.width, this.height));
        return bb;
    }

    @Override
    protected boolean localContains(double x, double y) {
        return x >= 0.0 && x < this.width && y >= 0.0 && y < this.height;
    }

    @Override
    protected void paint2d(Graphics2D g) {
        Rectangle2D.Double r = new Rectangle2D.Double(0.0, 0.0, this.width, this.height);
        if (this.isFilled()) {
            g.setColor(this.getFillColor());
            g.fill(r);
            g.setColor(this.getColor());
        }
        g.draw(r);
    }

    protected double getFrameWidth() {
        return this.width;
    }

    protected double getFrameHeight() {
        return this.height;
    }
}

