/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.graphics;

import edu.stanford.cs.graphics.GImageTools;
import edu.stanford.cs.graphics.ImageSaver;
import java.awt.Image;

class PICTImageSaver
extends ImageSaver {
    private static final int OP_CLIP = 1;
    private static final int OP_VERSION = 17;
    private static final int OP_DEF_HILITE = 30;
    private static final int OP_SHORT_LINE = 34;
    private static final int OP_DIRECT_BITS_RECT = 154;
    private static final int OP_SHORT_COMMENT = 160;
    private static final int OP_LONG_COMMENT = 161;
    private static final int OP_END_PICT = 255;
    private static final int OP_HEADER = 3072;
    private static final int PS_BEGIN = 190;
    private static final int PS_END = 191;
    private static final int PS_HANDLE = 192;
    private static final int PS_DICT_SIZE = 500;
    private static final int VERSION = 767;
    private static final int PICT_PADDING = 512;
    private static final int RGB_DIRECT = 16;
    private static final int SRC_COPY = 0;
    private int[][] pixels;
    private String[] psPreview;
    private int width;
    private int height;
    private int rowBytes;
    private boolean paddingFlag = true;

    PICTImageSaver() {
    }

    @Override
    public void saveImage(Image image) {
        this.pixels = GImageTools.getPixelArray(image);
        Object property = image.getProperty("PSPreview", null);
        this.psPreview = property instanceof String[] ? (String[])property : null;
        this.width = this.pixels[0].length;
        this.height = this.pixels.length;
        this.rowBytes = 4 * this.width;
        if (this.paddingFlag) {
            this.dumpPadding();
        }
        this.dumpHeader();
        this.dumpDefHilite();
        this.dumpClipRegion();
        this.dumpBoundsMarkers();
        if (this.psPreview != null) {
            this.dumpShort(160);
            this.dumpShort(190);
        }
        this.dumpDirectBitsRect();
        if (this.psPreview != null) {
            this.dumpPSPreview();
            this.dumpShort(160);
            this.dumpShort(191);
        }
        this.dumpEndPict();
    }

    public void setPaddingFlag(boolean flag) {
        this.paddingFlag = flag;
    }

    private void dumpPadding() {
        int i = 0;
        while (i < 512) {
            this.dumpByte(0);
            ++i;
        }
    }

    private void dumpHeader() {
        this.dumpShort(0);
        this.dumpShort(0);
        this.dumpShort(0);
        this.dumpShort(this.height);
        this.dumpShort(this.width);
        this.dumpShort(17);
        this.dumpShort(767);
        this.dumpShort(3072);
        this.dumpShort(65534);
        this.dumpShort(0);
        this.dumpShort(72);
        this.dumpShort(0);
        this.dumpShort(72);
        this.dumpShort(0);
        this.dumpShort(0);
        this.dumpShort(0);
        this.dumpShort(this.height);
        this.dumpShort(this.width);
        this.dumpInt(0);
    }

    private void dumpDefHilite() {
        this.dumpShort(30);
    }

    private void dumpClipRegion() {
        this.dumpShort(1);
        this.dumpShort(10);
        this.dumpShort(0);
        this.dumpShort(0);
        this.dumpShort(this.height);
        this.dumpShort(this.width);
    }

    private void dumpBoundsMarkers() {
        this.dumpShort(34);
        this.dumpShort(0);
        this.dumpShort(0);
        this.dumpShort(0);
        this.dumpShort(34);
        this.dumpShort(this.height);
        this.dumpShort(this.width);
        this.dumpShort(0);
    }

    private void dumpDirectBitsRect() {
        this.dumpShort(154);
        this.dumpPixMap();
        this.dumpShort(0);
        this.dumpShort(0);
        this.dumpShort(this.height);
        this.dumpShort(this.width);
        this.dumpShort(0);
        this.dumpShort(0);
        this.dumpShort(this.height);
        this.dumpShort(this.width);
        this.dumpShort(0);
        this.dumpPixelData();
    }

    private void dumpPixMap() {
        this.dumpInt(255);
        this.dumpShort(this.rowBytes | 0x8000);
        this.dumpShort(0);
        this.dumpShort(0);
        this.dumpShort(this.height);
        this.dumpShort(this.width);
        this.dumpShort(0);
        this.dumpShort(4);
        this.dumpInt(0);
        this.dumpShort(72);
        this.dumpShort(0);
        this.dumpShort(72);
        this.dumpShort(0);
        this.dumpShort(16);
        this.dumpShort(32);
        this.dumpShort(3);
        this.dumpShort(8);
        this.dumpInt(0);
        this.dumpInt(0);
        this.dumpInt(0);
    }

    private void dumpEndPict() {
        this.dumpShort(255);
    }

    private void dumpPixelData() {
        int byteCount = 0;
        byte[] data = new byte[this.rowBytes];
        int i = 0;
        while (i < this.height) {
            int nBytes = this.packScanLine(data, this.pixels[i]);
            if (this.rowBytes > 250) {
                this.dumpShort(nBytes);
                byteCount += 2;
            } else {
                this.dumpByte(nBytes);
                ++byteCount;
            }
            int j = 0;
            while (j < nBytes) {
                this.dumpByte(data[j]);
                ++j;
            }
            byteCount += nBytes;
            ++i;
        }
        if (byteCount % 2 == 1) {
            this.dumpByte(0);
        }
    }

    /*
     * Unable to fully structure code
     */
    private int packScanLine(byte[] data, int[] scanline) {
        flagIndex = 0;
        rgbIndex = 0;
        while (rgbIndex < 3) {
            rgb = "RGB".charAt(rgbIndex);
            baseIndex = flagIndex;
            dataIndex = flagIndex + 1;
            scanIndex = 0;
            while (scanIndex < this.width) {
                block9: {
                    b0 = this.getPixelComponent(scanline[scanIndex++], rgb);
                    data[dataIndex++] = (byte)b0;
                    runLength = 1;
                    matching = false;
                    if (scanIndex >= this.width) break block9;
                    b1 = this.getPixelComponent(scanline[scanIndex], rgb);
                    v0 = matching = b0 == b1;
                    if (!matching) ** GOTO lbl35
                    while (runLength < 128 && scanIndex < this.width) {
                        b1 = this.getPixelComponent(scanline[scanIndex], rgb);
                        if (b0 == b1) {
                            ++runLength;
                            ++scanIndex;
                            continue;
                        }
                        break block9;
                    }
                    break block9;
lbl-1000:
                    // 1 sources

                    {
                        b1 = this.getPixelComponent(scanline[scanIndex], rgb);
                        if (b0 == b1) {
                            --dataIndex;
                            --runLength;
                            --scanIndex;
                            break;
                        }
                        data[dataIndex++] = (byte)b1;
                        b0 = b1;
                        ++runLength;
                        ++scanIndex;
lbl35:
                        // 2 sources

                        ** while (runLength < 128 && scanIndex < this.width)
                    }
                }
                data[flagIndex] = matching != false ? (byte)(128 | 129 - runLength) : (byte)(runLength - 1);
                flagIndex = dataIndex++;
            }
            if (flagIndex - baseIndex > this.width + this.width / 128) {
                count = this.width;
                flagIndex = baseIndex;
                i = 0;
                while (i < this.width) {
                    if (i % 128 == 0) {
                        nBytes = count > 128 ? 128 : count;
                        data[flagIndex++] = (byte)(nBytes - 1);
                        count -= nBytes;
                    }
                    data[flagIndex++] = (byte)this.getPixelComponent(scanline[i], rgb);
                    ++i;
                }
            }
            ++rgbIndex;
        }
        return flagIndex;
    }

    private void dumpPSPreview() {
        this.addPSComment("/dictCount countdictstack def");
        this.addPSComment("/opCount count 1 sub def");
        this.addPSComment("500 dict begin");
        this.addPSComment("/showpage {} def");
        this.addPSComment("0 setgray 0 setlinecap");
        this.addPSComment("1 setlinewidth 0 setlinejoin");
        this.addPSComment("10 setmiterlimit [] 0 setdash");
        this.addPSComment("/languagelevel where {");
        this.addPSComment("  pop languagelevel");
        this.addPSComment("  1 ne { false setstrokeadjust false setoverprint } if");
        this.addPSComment("} if");
        this.addPSComment("gsave");
        this.addPSComment("clippath pathbbox");
        this.addPSComment("pop pop " + this.height + " add translate");
        this.addPSComment("1 -1 scale");
        int i = 0;
        while (i < this.psPreview.length) {
            this.addPSComment(this.psPreview[i]);
            ++i;
        }
        this.addPSComment("grestore");
        this.addPSComment("end");
        this.addPSComment("count opCount sub {pop} repeat");
        this.addPSComment("countdictstack dictCount sub {end} repeat");
    }

    private void addPSComment(String line) {
        if (line.length() % 2 == 0) {
            line = String.valueOf(line) + " ";
        }
        this.dumpShort(161);
        this.dumpShort(192);
        this.dumpShort(line.length() + 1);
        int i = 0;
        while (i < line.length()) {
            this.dumpByte(line.charAt(i));
            ++i;
        }
        this.dumpByte(13);
    }
}

