/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.java2js;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.TreeMap;

public class JSCookie {
    public static final String COOKIE_PATH = "/tmp/cookies.txt";

    public static void set(String name, String value) {
        TreeMap<String, String> cookies = JSCookie.readCookies();
        cookies.put(name, value);
        JSCookie.writeCookies(cookies);
    }

    public static void set(String name, String value, int days) {
        JSCookie.set(name, value);
    }

    public static void remove(String name) {
        TreeMap<String, String> cookies = JSCookie.readCookies();
        cookies.remove(name);
        JSCookie.writeCookies(cookies);
    }

    public static String get(String name) {
        return JSCookie.readCookies().get(name);
    }

    public static String[] getNames() {
        TreeMap<String, String> cookies = JSCookie.readCookies();
        String[] names = new String[cookies.size()];
        int n = 0;
        for (String name : cookies.keySet()) {
            names[n++] = name;
        }
        return names;
    }

    private static TreeMap<String, String> readCookies() {
        TreeMap<String, String> cookies = new TreeMap<String, String>();
        BufferedReader rd = null;
        try {
            String line;
            rd = new BufferedReader(new FileReader(COOKIE_PATH));
            while ((line = rd.readLine()) != null) {
                int equals = line.indexOf("=");
                if (equals == -1) {
                    rd.close();
                    throw new RuntimeException("Illegal cookie file");
                }
                String name = line.substring(0, equals);
                String value = line.substring(equals + 1);
                cookies.put(name, value);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (rd != null) {
            try {
                rd.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return cookies;
    }

    private static void writeCookies(TreeMap<String, String> cookies) {
        try {
            PrintWriter wr = new PrintWriter(new BufferedWriter(new FileWriter(COOKIE_PATH)));
            for (String name : cookies.keySet()) {
                String value = cookies.get(name);
                wr.println(String.valueOf(name) + "=" + value);
            }
            wr.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't create cookie file");
        }
    }
}

