/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.jseditor;

import java.util.HashMap;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;

public class FixedTabSet
extends TabSet {
    private HashMap<Integer, TabStop> tabStops = new HashMap();
    private int tabWidth;

    public FixedTabSet(int width) {
        super(new TabStop[0]);
        this.tabWidth = width;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof FixedTabSet && this.tabWidth == ((FixedTabSet)obj).tabWidth;
    }

    @Override
    public TabStop getTab(int index) {
        return this.makeTab(this.tabWidth * index);
    }

    @Override
    public TabStop getTabAfter(float location) {
        return this.makeTab(this.tabWidth * ((int)Math.floor(location / (float)this.tabWidth) + 1));
    }

    @Override
    public int getTabIndex(TabStop tab) {
        for (int index : this.tabStops.keySet()) {
            if (this.tabStops.get(index) != tab) continue;
            return index;
        }
        return -1;
    }

    @Override
    public int getTabIndexAfter(float location) {
        return this.getTabIndex(this.getTabAfter(location));
    }

    @Override
    public int hashCode() {
        return this.tabWidth;
    }

    @Override
    public String toString() {
        return "FixedTabSet(" + this.tabWidth + ")";
    }

    private TabStop makeTab(int location) {
        TabStop tab = this.tabStops.get(location);
        if (tab == null) {
            tab = new TabStop(location);
            this.tabStops.put(location, tab);
        }
        return tab;
    }
}

