/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.parser;

import edu.stanford.cs.exp.Compound;
import edu.stanford.cs.exp.Constant;
import edu.stanford.cs.exp.Expression;
import edu.stanford.cs.exp.Identifier;
import edu.stanford.cs.exp.Value;
import edu.stanford.cs.parser.CodeVector;
import edu.stanford.cs.parser.Operator;
import edu.stanford.cs.parser.SyntaxError;
import edu.stanford.cs.tokenscanner.TokenScanner;
import java.util.HashMap;

public class Parser {
    private TokenScanner scanner = this.createTokenScanner();
    private HashMap<String, Operator> operators = new HashMap();
    private boolean markCodeFlag;

    public Expression parse() {
        Expression exp = this.readE(0);
        String token = this.nextToken();
        if (!token.equals("")) {
            throw new SyntaxError("Unexpected token: " + this.markCode(token));
        }
        return exp;
    }

    public Expression readE(int precedence) {
        Expression exp = this.readT();
        String token = this.nextToken();
        while (this.takesPrecedence(token, precedence)) {
            Operator op = this.getOperator(token);
            if (op.isStatement()) {
                throw new SyntaxError("Illegal context for " + this.markCode("" + op));
            }
            exp = op.infixAction(this, exp);
            token = this.nextToken();
        }
        this.saveToken(token);
        return exp;
    }

    public Expression readT() {
        String token = this.nextToken();
        if (token == null) {
            throw new SyntaxError("Unexpected end of line");
        }
        switch (this.scanner.getTokenType(token)) {
            case 1: 
            case 4: {
                Operator op = this.getOperator(token);
                if (op == null) {
                    return this.createIdentifier(token);
                }
                if (op.isStatement()) {
                    throw new SyntaxError("Illegal context for " + this.markCode("" + op));
                }
                return op.prefixAction(this);
            }
        }
        return this.parseConstant(token);
    }

    public String unparse(Expression exp) {
        switch (exp.getType()) {
            case 1: {
                return this.unparseConstant((Constant)exp);
            }
            case 2: {
                return this.unparseIdentifier((Identifier)exp);
            }
            case 3: {
                Expression fn = exp.getFunction();
                Expression[] args = exp.getArgs();
                if (fn.getType() == 4) {
                    return ((Operator)fn).unparse(this, args);
                }
                String result = fn.toString();
                result = String.valueOf(result) + "(";
                int i = 0;
                while (i < args.length) {
                    if (i > 0) {
                        result = String.valueOf(result) + ",";
                    }
                    result = String.valueOf(result) + this.unparse(args[i]);
                    ++i;
                }
                return String.valueOf(result) + ")";
            }
        }
        return exp.toString();
    }

    public String unparseIdentifier(Identifier id) {
        return id.getName();
    }

    public String unparseConstant(Constant c) {
        Value value = c.getValue();
        switch (value.getType()) {
            case 83: {
                return Parser.unparseString((String)value.getValue());
            }
            case 67: {
                return Parser.unparseChar(((Character)value.getValue()).charValue());
            }
        }
        return value.toString();
    }

    public static String unparseString(String str) {
        String result = "\"";
        int len = str.length();
        int i = 0;
        while (i < len) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\b': {
                    result = String.valueOf(result) + "\\b";
                    break;
                }
                case '\f': {
                    result = String.valueOf(result) + "\\f";
                    break;
                }
                case '\n': {
                    result = String.valueOf(result) + "\\n";
                    break;
                }
                case '\r': {
                    result = String.valueOf(result) + "\\r";
                    break;
                }
                case '\t': {
                    result = String.valueOf(result) + "\\t";
                    break;
                }
                case '\\': {
                    result = String.valueOf(result) + "\\\\";
                    break;
                }
                case '\"': {
                    result = String.valueOf(result) + "\\\"";
                    break;
                }
                default: {
                    if (ch >= ' ' && ch < '\u007f') {
                        result = String.valueOf(result) + (char)ch;
                        break;
                    }
                    if (ch < '\u0100') {
                        String oct = "000" + Integer.toString(ch, 8);
                        result = String.valueOf(result) + "\\" + oct.substring(oct.length() - 3);
                        break;
                    }
                    String hex = "0000" + Integer.toString(ch, 16).toUpperCase();
                    result = String.valueOf(result) + "\\u" + hex.substring(hex.length() - 4);
                }
            }
            ++i;
        }
        return String.valueOf(result) + "\"";
    }

    public static String unparseChar(char ch) {
        String result = "'";
        switch (ch) {
            case '\b': {
                result = String.valueOf(result) + "\\b";
                break;
            }
            case '\f': {
                result = String.valueOf(result) + "\\f";
                break;
            }
            case '\n': {
                result = String.valueOf(result) + "\\n";
                break;
            }
            case '\r': {
                result = String.valueOf(result) + "\\r";
                break;
            }
            case '\t': {
                result = String.valueOf(result) + "\\t";
                break;
            }
            case '\\': {
                result = String.valueOf(result) + "\\\\";
                break;
            }
            case '\'': {
                result = String.valueOf(result) + "\\'";
                break;
            }
            default: {
                if (ch >= ' ' && ch < '\u007f') {
                    result = String.valueOf(result) + ch;
                    break;
                }
                if (ch < '\u0100') {
                    String oct = "000" + Integer.toString(ch, 8);
                    result = String.valueOf(result) + "\\" + oct.substring(oct.length() - 3);
                    break;
                }
                String hex = "0000" + Integer.toString(ch, 16).toUpperCase();
                result = String.valueOf(result) + "\\u" + hex.substring(hex.length() - 4);
            }
        }
        return String.valueOf(result) + "'";
    }

    public void compile(Expression exp, CodeVector cv) {
        throw new SyntaxError("No compiler defined");
    }

    public void definePrefixOperator(String name, Operator op, int prec) {
        this.defineOperator(name, op, prec, 0, 0);
    }

    public void defineInfixOperator(String name, Operator op, int prec, int assoc) {
        this.defineOperator(name, op, 0, prec, assoc);
    }

    public void defineOperator(String name, Operator op, int prefix, int infix, int assoc) {
        op.setName(name);
        op.setPrefixPrecedence(prefix);
        op.setInfixPrecedence(infix);
        op.setAssociativity(assoc);
        this.operators.put(name, op);
    }

    public void removeOperator(String name) {
        this.operators.remove(name);
    }

    public HashMap<String, Operator> getOperatorTable() {
        return this.operators;
    }

    public Operator getOperator(String name) {
        return this.operators.get(name);
    }

    public TokenScanner getTokenScanner() {
        return this.scanner;
    }

    public void setInput(String str) {
        this.scanner.setInput(str);
    }

    public boolean hasMoreTokens() {
        return this.scanner.hasMoreTokens();
    }

    public String nextToken() {
        return this.scanner.nextToken();
    }

    public void saveToken(String token) {
        this.scanner.saveToken(token);
    }

    public int getTokenType(String token) {
        return this.scanner.getTokenType(token);
    }

    public String getStringValue(String token) {
        return this.scanner.getStringValue(token);
    }

    public int getPosition() {
        return this.scanner.getPosition();
    }

    public void verifyToken(String expected) {
        String token = this.nextToken();
        if (token.equals(expected)) {
            return;
        }
        String msg = "";
        msg = token.equals("") ? "Missing " + this.markCode(expected) : "Found " + this.markCode(token) + " when expecting " + this.markCode(expected);
        throw new SyntaxError(msg);
    }

    public boolean takesPrecedence(String token, int prec) {
        if (token == null) {
            return false;
        }
        Operator op = this.getOperator(token);
        if (op == null) {
            return false;
        }
        int newprec = op.getInfixPrecedence();
        if (newprec == prec) {
            return op.getAssociativity() == 1;
        }
        return newprec > prec;
    }

    public void setMarkCodeFlag(boolean flag) {
        this.markCodeFlag = flag;
    }

    public boolean getMarkCodeFlag() {
        return this.markCodeFlag;
    }

    public String markCode(String str) {
        return this.markCodeFlag ? "<code>" + str + "</code>" : str;
    }

    public TokenScanner createTokenScanner() {
        TokenScanner scanner = new TokenScanner();
        scanner.ignoreWhitespace();
        scanner.scanStrings();
        scanner.scanNumbers();
        return scanner;
    }

    public Identifier createIdentifier(String name) {
        return new Identifier(name);
    }

    public Constant createConstant(Value value) {
        return new Constant(value);
    }

    public Expression parseConstant(String str) {
        int type = this.scanner.getTokenType(str);
        if (type == 2) {
            if (str.indexOf(".") >= 0) {
                return this.createConstant(Value.createDouble(Double.parseDouble(str)));
            }
            return this.createConstant(Value.createInteger(Integer.parseInt(str)));
        }
        if (type == 3) {
            if (str.startsWith("'")) {
                char c = this.scanner.getStringValue(str).charAt(0);
                return this.createConstant(Value.createCharacter(c));
            }
            String s = this.scanner.getStringValue(str);
            return this.createConstant(Value.createString(s));
        }
        throw new SyntaxError("Illegal constant: " + this.markCode(str));
    }

    public Expression createCompound(Expression op, Expression[] args) {
        return new Compound(op, args);
    }

    public final Expression createCompound0(Expression op) {
        return this.createCompound(op, new Expression[0]);
    }

    public final Expression createCompound1(Expression op, Expression a1) {
        Expression[] args = new Expression[]{a1};
        return this.createCompound(op, args);
    }

    public Expression createCompound2(Expression op, Expression a1, Expression a2) {
        Expression[] args = new Expression[]{a1, a2};
        return this.createCompound(op, args);
    }

    public Expression createCompound3(Expression op, Expression a1, Expression a2, Expression a3) {
        Expression[] args = new Expression[]{a1, a2, a3};
        return this.createCompound(op, args);
    }

    public Expression createCompound4(Expression op, Expression a1, Expression a2, Expression a3, Expression a4) {
        Expression[] args = new Expression[]{a1, a2, a3, a4};
        return this.createCompound(op, args);
    }

    public Expression createCompound5(Expression op, Expression a1, Expression a2, Expression a3, Expression a4, Expression a5) {
        Expression[] args = new Expression[]{a1, a2, a3, a4, a5};
        return this.createCompound(op, args);
    }
}

