/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.shellargs;

import java.awt.Color;
import java.util.ArrayList;
import java.util.TreeMap;

public class ShellArgs {
    private TreeMap<String, String> options = new TreeMap();
    private ArrayList<String> files = new ArrayList();

    public ShellArgs(String[] args, String[] optionSpec) {
        int nArgs = args.length;
        String key = null;
        String value = "true";
        int i = 0;
        while (i < nArgs) {
            String arg = args[i];
            if (arg.startsWith("-") && arg.length() > 1) {
                int index = this.findOptionSpec(arg, optionSpec);
                String spec = optionSpec[index];
                int space = spec.indexOf(" ");
                if (space == -1) {
                    key = spec;
                } else {
                    key = spec.substring(0, space);
                    if (++i == nArgs) {
                        throw new RuntimeException("Missing value after " + arg);
                    }
                    String str = args[i];
                    while (i + 1 < nArgs && args[i + 1].equals("+")) {
                        if ((i += 2) == nArgs) {
                            throw new RuntimeException("Missing value after +");
                        }
                        str = String.valueOf(str) + args[i];
                    }
                    value = str;
                }
                this.options.put(key, value);
            } else {
                this.files.add(arg);
            }
            ++i;
        }
    }

    public String[] getFiles() {
        return this.files.toArray(new String[this.files.size()]);
    }

    public boolean isOptionSpecified(String key) {
        return this.options.containsKey(key);
    }

    public String getOption(String key) {
        return this.options.get(key);
    }

    public String getOption(String key, String def) {
        String str = this.options.get(key);
        return str == null ? def : str;
    }

    public int getIntOption(String key) {
        return this.getIntOption(key, 0);
    }

    public int getIntOption(String key, int def) {
        String str = this.options.get(key);
        return str == null ? def : Integer.parseInt(str);
    }

    public double getDoubleOption(String key) {
        return this.getDoubleOption(key, 0.0);
    }

    public double getDoubleOption(String key, double def) {
        String str = this.options.get(key);
        return str == null ? def : Double.parseDouble(str);
    }

    public boolean getBooleanOption(String key) {
        return this.getBooleanOption(key, false);
    }

    public boolean getBooleanOption(String key, boolean def) {
        String str = this.options.get(key);
        if (str == null || str.isEmpty()) {
            return def;
        }
        if ("false".startsWith(str.toLowerCase())) {
            return false;
        }
        if ("true".startsWith(str.toLowerCase())) {
            return true;
        }
        throw new RuntimeException("Illegal boolean value");
    }

    public double getUnitsOption(String key) {
        return this.getUnitsOption(key, 0.0);
    }

    public double getUnitsOption(String key, double def) {
        String str = this.options.get(key);
        if (str == null || str.isEmpty()) {
            return def;
        }
        double units = 1.0;
        if (str.endsWith("pt")) {
            str = str.substring(0, str.length() - 2);
        } else if (str.endsWith("px")) {
            str = str.substring(0, str.length() - 2);
        } else if (str.endsWith("i")) {
            str = str.substring(0, str.length() - 1);
            units = 72.0;
        } else if (str.endsWith("in")) {
            str = str.substring(0, str.length() - 2);
            units = 72.0;
        } else if (str.endsWith("cm")) {
            str = str.substring(0, str.length() - 2);
            units = 28.346456692913385;
        }
        return Double.parseDouble(str) * units;
    }

    public Color getColorOption(String key) {
        return this.getColorOption(key, null);
    }

    public Color getColorOption(String key, Color def) {
        String str = this.options.get(key);
        if (str == null || str.isEmpty()) {
            return def;
        }
        if (str.equalsIgnoreCase("black")) {
            return Color.BLACK;
        }
        if (str.equalsIgnoreCase("blue")) {
            return Color.BLUE;
        }
        if (str.equalsIgnoreCase("cyan")) {
            return Color.CYAN;
        }
        if (str.equalsIgnoreCase("darkGray")) {
            return Color.DARK_GRAY;
        }
        if (str.equalsIgnoreCase("DARK_GRAY")) {
            return Color.DARK_GRAY;
        }
        if (str.equalsIgnoreCase("gray")) {
            return Color.GRAY;
        }
        if (str.equalsIgnoreCase("green")) {
            return Color.GREEN;
        }
        if (str.equalsIgnoreCase("lightGray")) {
            return Color.LIGHT_GRAY;
        }
        if (str.equalsIgnoreCase("LIGHT_GRAY")) {
            return Color.LIGHT_GRAY;
        }
        if (str.equalsIgnoreCase("magenta")) {
            return Color.MAGENTA;
        }
        if (str.equalsIgnoreCase("orange")) {
            return Color.ORANGE;
        }
        if (str.equalsIgnoreCase("pink")) {
            return Color.PINK;
        }
        if (str.equalsIgnoreCase("red")) {
            return Color.RED;
        }
        if (str.equalsIgnoreCase("white")) {
            return Color.WHITE;
        }
        if (str.equalsIgnoreCase("yellow")) {
            return Color.YELLOW;
        }
        if (str.startsWith("0x")) {
            str = str.substring(2);
        } else if (str.startsWith("#")) {
            str = str.substring(1);
        }
        if (!this.isHexString(str)) {
            throw new RuntimeException("Illegal color option");
        }
        int nDigits = str.length();
        int aa = 255;
        if (nDigits == 8) {
            aa = Integer.parseInt(str.substring(0, 2), 16);
            str = str.substring(2);
        } else if (nDigits != 6) {
            throw new RuntimeException("Color options must have 6 or 8 hexadecimal digits");
        }
        return new Color(Integer.parseInt(str, 16) | aa << 24, true);
    }

    public void showUsage(String usage, String[] optionSpec) {
        System.out.println("Usage: " + usage);
        System.out.println("  where <options> can be any of the following:");
        String[] stringArray = optionSpec;
        int n = optionSpec.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            System.out.println("   " + option);
            ++n2;
        }
    }

    private boolean isHexString(String str) {
        int n = str.length();
        int i = 0;
        while (i < n) {
            if ("0123456789ABCDEFabcdef".indexOf(str.substring(i, i + 1)) == -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int findOptionSpec(String arg, String[] optionSpec) {
        int index = -1;
        int nSpec = optionSpec.length;
        int i = 0;
        while (i < nSpec) {
            if (optionSpec[i].startsWith(arg)) {
                if (index == -1) {
                    index = i;
                } else {
                    throw new RuntimeException("Ambiguous option: " + arg);
                }
            }
            ++i;
        }
        if (index == -1) {
            throw new RuntimeException("Unrecognized option: " + arg);
        }
        return index;
    }
}

