/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.sjs;

import edu.stanford.cs.exp.Expression;
import edu.stanford.cs.exp.Value;
import edu.stanford.cs.java2js.JSPackage;
import edu.stanford.cs.parser.CodeVector;
import edu.stanford.cs.sjs.SJSCommandMonitor;
import edu.stanford.cs.sjs.SJSParser;
import edu.stanford.cs.svm.SVM;
import edu.stanford.cs.svm.SVMFunctionClosure;
import edu.stanford.cs.svm.SVMModule;

public class SJSCompiler {
    private SVM svm;
    private SJSParser parser;
    private SJSCommandMonitor monitor;

    public SJSCompiler(SVM svm, SJSParser parser, SJSCommandMonitor monitor) {
        this.svm = svm;
        this.parser = parser;
        this.monitor = monitor;
    }

    public SVM getSVM() {
        return this.svm;
    }

    public SJSParser getParser() {
        return this.parser;
    }

    public SJSCommandMonitor getCommandMonitor() {
        return this.monitor;
    }

    public CodeVector executeModule(String pathname, SVMModule module) {
        CodeVector cv = new CodeVector();
        for (String name : module.getImports()) {
            if (name.indexOf(".") != -1) continue;
            String pkg = "edu.stanford.cs.sjslib." + name;
            JSPackage.load(pkg, (Object)this.svm);
        }
        this.parser.compileFunctions(module.getFunctions(), cv);
        int[] code = cv.getCode();
        for (Expression fn : module.getFunctions()) {
            Expression[] args = fn.getArgs();
            String name = args[0].getName();
            int addr = cv.getLabel(name);
            SVMFunctionClosure closure = new SVMFunctionClosure(code, addr, null);
            this.svm.setGlobal(name, Value.createObject(closure, "FunctionClosure"));
        }
        CodeVector ncv = new CodeVector();
        for (Expression exp : module.getGlobals()) {
            Expression[] args = exp.getArgs()[0].getArgs();
            ncv.addInstruction(18, ncv.stringRef(args[0].getName()));
            this.parser.compile(args[1], ncv);
            ncv.addInstruction(97, ncv.stringRef("Global.set"));
        }
        ncv.addInstruction(0, 0);
        code = ncv.getCode();
        this.svm.reset();
        this.svm.setCode(code);
        this.svm.pushExceptionFrame(-999);
        this.svm.setState(1);
        while (code[this.svm.getPC()] != 0) {
            this.svm.executeInstruction();
        }
        this.svm.reset();
        return cv;
    }

    public void compileModule(SVMModule module, CodeVector cv, String main) {
        String init = cv.newLabel();
        cv.addInstruction(96, cv.labelRef(init));
        if (main != null) {
            cv.addInstruction(108, cv.stringRef(main));
            cv.addInstruction(98, 0);
        }
        cv.addInstruction(4, 0);
        this.parser.compileFunctions(module.getFunctions(), cv);
        cv.defineLabel(init);
        for (Expression fn : module.getFunctions()) {
            String name = fn.getArgs()[0].getName();
            if (!fn.getArgs()[4].getValue().getBooleanValue()) continue;
            cv.addInstruction(18, cv.stringRef(name));
            cv.addInstruction(19, cv.getLabel(name));
            cv.addInstruction(97, cv.stringRef("Global.set"));
        }
        for (Expression exp : module.getGlobals()) {
            Expression[] args = exp.getArgs()[0].getArgs();
            Expression lhs = args[0];
            Expression rhs = args[1];
            cv.addInstruction(18, cv.stringRef(lhs.getName()));
            this.parser.compile(rhs, cv);
            cv.addInstruction(97, cv.stringRef("Global.set"));
        }
        cv.addInstruction(99, 0);
    }
}

