/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.sjs;

import edu.stanford.cs.exp.Value;
import edu.stanford.cs.graphics.GCanvas;
import edu.stanford.cs.graphics.GWindow;
import edu.stanford.cs.java2js.JSFrame;
import edu.stanford.cs.sjs.SJSGWindowListener;
import edu.stanford.cs.sjs.SJSListenerPair;
import edu.stanford.cs.sjs.SJSVM;
import edu.stanford.cs.svm.SVMEventClosure;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;

public class SJSGWindow
extends GCanvas
implements ActionListener,
KeyListener,
MouseListener,
MouseMotionListener {
    public static final int NORMAL = 0;
    public static final int WAITING_FOR_CLICK = 1;
    public static final int WAITING_FOR_EVENT = 2;
    private ArrayList<SJSListenerPair> jsListeners;
    private GWindow frame;
    private JSFrame jsFrame;
    private SJSVM svm;
    private boolean hasKeyListener;
    private boolean hasMouseListener;
    private boolean hasMouseMotionListener;
    private int state;

    public SJSGWindow(SJSVM svm) {
        this.svm = svm;
        this.hasMouseListener = false;
        this.hasMouseMotionListener = false;
        this.state = 0;
        this.frame = null;
        this.jsListeners = new ArrayList();
    }

    public SJSVM getSVM() {
        return this.svm;
    }

    public void setTitle(String title) {
        if (this.frame != null) {
            this.frame.setTitle(title);
        } else if (this.jsFrame != null) {
            this.jsFrame.setTitle(title);
        }
    }

    public void createJSFrame(double width, double height) {
        Dimension size = new Dimension((int)Math.round(width), (int)Math.round(height));
        this.setPreferredSize(size);
        this.jsFrame = new JSFrame(this, "Graphics Window");
    }

    public JSFrame getJSFrame() {
        return this.jsFrame;
    }

    public void createFrame(double width, double height) {
        this.frame = new GWindow(this);
        if (this.svm.getFrame() != null) {
            this.frame.setDefaultCloseOperation(0);
        }
        Dimension size = new Dimension((int)Math.round(width), (int)Math.round(height));
        this.setPreferredSize(size);
        this.frame.addWindowListener(new SJSGWindowListener(this));
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public GWindow getFrame() {
        return this.frame;
    }

    public void close() {
        this.svm.closeGWindow(this);
    }

    public void setState(int state) {
        this.state = state;
    }

    public void enableKeyListener() {
        if (!this.hasKeyListener) {
            this.addKeyListener(this);
            this.hasKeyListener = true;
        }
    }

    public void enableMouseListener() {
        if (!this.hasMouseListener) {
            this.addMouseListener(this);
            this.hasMouseListener = true;
        }
    }

    public void enableMouseMotionListener() {
        if (!this.hasMouseMotionListener) {
            this.addMouseMotionListener(this);
            this.hasMouseMotionListener = true;
        }
    }

    public void addEventListener(String type, Value callback) {
        if (type.equals("click")) {
            this.enableMouseListener();
        } else if (type.equals("mouseclick") || type.equals("mouseClicked")) {
            type = "click";
            this.enableMouseListener();
        } else if (type.equals("mousedown")) {
            this.enableMouseListener();
        } else if (type.equals("mousePressed")) {
            type = "mousedown";
            this.enableMouseListener();
        } else if (type.equals("mouseup")) {
            this.enableMouseListener();
        } else if (type.equals("mouseReleased")) {
            type = "mouseup";
            this.enableMouseListener();
        } else if (type.equals("mousemove")) {
            this.enableMouseMotionListener();
        } else if (type.equals("mouseMoved")) {
            type = "mousemove";
            this.enableMouseMotionListener();
        } else if (type.equals("drag")) {
            this.enableMouseMotionListener();
        } else if (type.equals("mousedrag") || type.equals("mouseDragged")) {
            type = "drag";
            this.enableMouseMotionListener();
        } else {
            throw new RuntimeException("Unimplemented event " + type);
        }
        this.jsListeners.add(new SJSListenerPair(type.toLowerCase(), callback));
    }

    public boolean hasActiveListeners() {
        return this.hasMouseListener || this.hasMouseMotionListener;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.state == 2) {
            this.state = 0;
            this.svm.push(Value.createObject(e, "ActionEvent"));
            this.svm.run();
            this.repaint();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.fireKeyEvent(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.fireKeyEvent(e);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.fireKeyEvent(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.jsListeners.isEmpty()) {
            if (this.state == 1) {
                this.state = 0;
                this.svm.run();
                this.repaint();
            } else {
                this.fireMouseEvent(e);
            }
        } else {
            for (SJSListenerPair pair : this.jsListeners) {
                if (!pair.eventType.equals("click")) continue;
                SVMEventClosure closure = new SVMEventClosure(pair.callback);
                closure.add(Value.createObject(e, "MouseEvent"));
                this.svm.postEvent(closure);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.jsListeners.isEmpty()) {
            this.fireMouseEvent(e);
        } else {
            for (SJSListenerPair pair : this.jsListeners) {
                if (!pair.eventType.equals("mousedown")) continue;
                SVMEventClosure closure = new SVMEventClosure(pair.callback);
                closure.add(Value.createObject(e, "MouseEvent"));
                this.svm.postEvent(closure);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.jsListeners.isEmpty()) {
            this.fireMouseEvent(e);
        } else {
            for (SJSListenerPair pair : this.jsListeners) {
                if (!pair.eventType.equals("mouseup")) continue;
                SVMEventClosure closure = new SVMEventClosure(pair.callback);
                closure.add(Value.createObject(e, "MouseEvent"));
                this.svm.postEvent(closure);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.jsListeners.isEmpty()) {
            this.fireMouseEvent(e);
        } else {
            for (SJSListenerPair pair : this.jsListeners) {
                if (!pair.eventType.equals("mousemove")) continue;
                SVMEventClosure closure = new SVMEventClosure(pair.callback);
                closure.add(Value.createObject(e, "MouseEvent"));
                this.svm.postEvent(closure);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.jsListeners.isEmpty()) {
            this.fireMouseEvent(e);
        } else {
            for (SJSListenerPair pair : this.jsListeners) {
                if (!pair.eventType.equals("drag")) continue;
                SVMEventClosure closure = new SVMEventClosure(pair.callback);
                closure.add(Value.createObject(e, "MouseEvent"));
                this.svm.postEvent(closure);
            }
        }
    }

    private void fireMouseEvent(MouseEvent e) {
        if (this.state == 2) {
            this.state = 0;
            this.svm.push(Value.createObject(e, "MouseEvent"));
            this.svm.run();
            this.repaint();
        }
    }

    private void fireKeyEvent(KeyEvent e) {
        if (this.state == 2) {
            this.state = 0;
            this.svm.push(Value.createObject(e, "KeyEvent"));
            this.svm.run();
            this.repaint();
        }
    }
}

