/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.svm;

import edu.stanford.cs.parser.CodeVector;
import edu.stanford.cs.svm.SVM;
import edu.stanford.cs.svm.SVMInstruction;
import edu.stanford.cs.tokenscanner.TokenScanner;

class PUSHNUM_Ins
extends SVMInstruction {
    public PUSHNUM_Ins() {
        super("PUSHNUM", 17);
    }

    @Override
    public void assemble(CodeVector cv, TokenScanner scanner) {
        String token = scanner.nextToken();
        if (token.equals("-")) {
            token = String.valueOf(token) + scanner.nextToken();
        }
        cv.addWord(this.getCode() << 24 | cv.stringRef(token));
    }

    @Override
    public void execute(SVM svm, int addr) {
        String str = svm.getString(addr);
        if (str.indexOf(".") == -1 && str.toUpperCase().indexOf("E") == -1) {
            svm.pushInteger(Integer.parseInt(str));
        } else {
            svm.pushDouble(Double.parseDouble(str));
        }
    }

    @Override
    public String unparse(SVM svm, int addr) {
        return "PUSHNUM " + svm.getString(addr);
    }
}

