/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.svm;

import edu.stanford.cs.exp.Value;
import edu.stanford.cs.svm.SVM;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class SVMConsoleListener
implements ActionListener {
    private SVM svm;

    public SVMConsoleListener(SVM svm) {
        this.svm = svm;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean ok = false;
        String key = "";
        if (this.svm.isGlobal("CONSOLE_WAIT")) {
            Value action = this.svm.getGlobal("CONSOLE_WAIT");
            if (action.getType() == 83) {
                key = action.getStringValue();
                if (key.startsWith("getInt")) {
                    try {
                        this.svm.pushInteger(Integer.parseInt(e.getActionCommand()));
                        ok = true;
                    }
                    catch (RuntimeException ex) {
                        this.svm.getConsole().showErrorMessage(ex.getMessage());
                    }
                } else if (key.startsWith("getNumber")) {
                    try {
                        this.svm.pushDouble(Double.parseDouble(e.getActionCommand()));
                        ok = true;
                    }
                    catch (RuntimeException ex) {
                        this.svm.getConsole().showErrorMessage(ex.getMessage());
                    }
                } else {
                    this.svm.pushString(e.getActionCommand());
                    ok = true;
                }
            } else if (action.getClassName().equals("FunctionClosure")) {
                this.svm.pushString(e.getActionCommand());
                this.svm.push(action);
                this.svm.call(1);
                return;
            }
            if (ok) {
                this.svm.run();
            } else {
                String prompt = "";
                int colon = key.indexOf(":");
                if (colon > 0) {
                    prompt = key.substring(colon + 1);
                }
                this.svm.getConsole().requestInput(prompt);
            }
        } else {
            this.processConsoleLine(e.getActionCommand());
        }
    }

    protected void processConsoleLine(String line) {
    }
}

