/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.console;

import edu.stanford.cs.console.Console;
import edu.stanford.cs.console.ConsolePane;
import java.awt.Font;
import javax.swing.JFrame;

public class ConsoleWindow
extends JFrame
implements Console {
    public static final Font DEFAULT_FONT = Font.decode("Monospaced-12");
    public static final int DEFAULT_WIDTH = 500;
    public static final int DEFAULT_HEIGHT = 300;
    private ConsolePane cpane = new ConsolePane();

    public ConsoleWindow() {
        this(500.0, 300.0);
    }

    public ConsoleWindow(double width, double height) {
        super("Console Window");
        this.setFont(DEFAULT_FONT);
        this.cpane.setSize((int)Math.round(width), (int)Math.round(height));
        this.cpane.setPreferredSize(this.cpane.getSize());
        this.add(this.cpane);
        this.pack();
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
    }

    public void clear() {
        this.cpane.clear();
    }

    @Override
    public void print(Object value) {
        this.cpane.print(value.toString());
    }

    @Override
    public void println() {
        this.cpane.print("\n");
    }

    @Override
    public void println(Object value) {
        this.print(value);
        this.println();
    }

    @Override
    public void printf(String format, Object ... args) {
        this.print(String.format(format, args));
    }

    @Override
    public void format(String format, Object ... args) {
        System.out.printf(format, args);
    }

    @Override
    public String nextLine() {
        return this.cpane.nextLine();
    }

    @Override
    public String nextLine(String prompt) {
        if (prompt != null) {
            this.print(prompt);
        }
        return this.nextLine();
    }

    @Override
    public int nextInt() {
        return this.nextInt(null);
    }

    @Override
    public int nextInt(String prompt) {
        while (true) {
            String line = this.nextLine(prompt);
            try {
                return Integer.parseInt(line);
            }
            catch (NumberFormatException ex) {
                this.println("Illegal integer format");
                if (prompt != null) continue;
                prompt = "Retry: ";
                continue;
            }
            break;
        }
    }

    @Override
    public double nextDouble() {
        return this.nextDouble(null);
    }

    @Override
    public double nextDouble(String prompt) {
        while (true) {
            String line = this.nextLine(prompt);
            try {
                return Double.parseDouble(line);
            }
            catch (NumberFormatException ex) {
                this.println("Illegal floating-point format");
                if (prompt != null) continue;
                prompt = "Retry: ";
                continue;
            }
            break;
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.cpane != null) {
            this.cpane.setFont(font);
        }
    }

    public void setFont(String str) {
        this.setFont(Font.decode(str));
    }
}

