/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.console;

import edu.stanford.cs.console.Console;
import java.io.IOException;

public class SystemConsole
implements Console {
    private int prevChar;

    @Override
    public void print(Object value) {
        System.out.print(value);
    }

    @Override
    public void println() {
        System.out.println();
    }

    @Override
    public void println(Object value) {
        System.out.println(value);
    }

    @Override
    public void printf(String format, Object ... args) {
        System.out.printf(format, args);
    }

    @Override
    public void format(String format, Object ... args) {
        System.out.printf(format, args);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String nextLine() {
        try {
            String line = "";
            while (true) {
                int ch;
                if ((ch = System.in.read()) == -1) {
                    return null;
                }
                if (ch == 13) {
                    if (this.prevChar != 10) {
                        this.prevChar = ch;
                        return line;
                    }
                } else if (ch == 10) {
                    if (this.prevChar != 13) {
                        this.prevChar = ch;
                        return line;
                    }
                } else {
                    line = String.valueOf(line) + (char)ch;
                }
                this.prevChar = ch;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    @Override
    public String nextLine(String prompt) {
        if (prompt != null) {
            this.print(prompt);
        }
        return this.nextLine();
    }

    @Override
    public int nextInt() {
        return this.nextInt(null);
    }

    @Override
    public int nextInt(String prompt) {
        while (true) {
            String line = this.nextLine(prompt);
            try {
                return Integer.parseInt(line);
            }
            catch (NumberFormatException ex) {
                this.println("Illegal integer format");
                if (prompt != null) continue;
                prompt = "Retry: ";
                continue;
            }
            break;
        }
    }

    @Override
    public double nextDouble() {
        return this.nextDouble(null);
    }

    @Override
    public double nextDouble(String prompt) {
        while (true) {
            String line = this.nextLine(prompt);
            try {
                return Double.parseDouble(line);
            }
            catch (NumberFormatException ex) {
                this.println("Illegal floating-point format");
                if (prompt != null) continue;
                prompt = "Retry: ";
                continue;
            }
            break;
        }
    }
}

