/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.graphics;

import edu.stanford.cs.graphics.GFillable;
import edu.stanford.cs.graphics.GMath;
import edu.stanford.cs.graphics.GObject;
import edu.stanford.cs.graphics.GPoint;
import edu.stanford.cs.graphics.GRectangle;
import edu.stanford.cs.graphics.GTransform;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;

public class GArc
extends GObject
implements GFillable {
    public static final double ARC_TOLERANCE = 2.5;
    private double width;
    private double height;
    private double start;
    private double sweep;
    private Color fillColor;
    private boolean isFilled;

    public GArc(double width, double height, double start, double sweep) {
        this(0.0, 0.0, width, height, start, sweep);
    }

    public GArc(double x, double y, double width, double height, double start, double sweep) {
        this.width = width;
        this.height = height;
        this.start = start;
        this.sweep = sweep;
        this.setLocation(x, y);
    }

    public void setStartAngle(double start) {
        this.start = start;
        this.repaint();
    }

    public double getStartAngle() {
        return this.start;
    }

    public void setSweepAngle(double sweep) {
        this.sweep = sweep;
        this.repaint();
    }

    public double getSweepAngle() {
        return this.sweep;
    }

    public GPoint getStartPoint() {
        GPoint pt = this.getCTM().transform(this.getArcPoint(this.start));
        pt.translate(this.getX(), this.getY());
        return pt;
    }

    public GPoint getEndPoint() {
        GPoint pt = this.getCTM().transform(this.getArcPoint(this.start + this.sweep));
        pt.translate(this.getX(), this.getY());
        return pt;
    }

    public void setFrameRectangle(double x, double y, double width, double height) {
        this.width = width;
        this.height = height;
        this.setLocation(x, y);
    }

    public final void setFrameRectangle(GRectangle bounds) {
        this.setFrameRectangle(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    public GRectangle getFrameRectangle() {
        return new GRectangle(this.getX(), this.getY(), this.width, this.height);
    }

    @Override
    public void setFilled(boolean fill) {
        this.isFilled = fill;
        this.repaint();
    }

    @Override
    public boolean isFilled() {
        return this.isFilled;
    }

    @Override
    public void setFillColor(Color color) {
        this.fillColor = color;
        this.repaint();
    }

    @Override
    public Color getFillColor() {
        return this.fillColor == null ? this.getColor() : this.fillColor;
    }

    @Override
    public String paramString() {
        String tail = super.paramString();
        tail = tail.substring(tail.indexOf(41) + 1);
        GRectangle r = this.getFrameRectangle();
        String param = "frame=(" + r.getX() + ", " + r.getY() + ", " + r.getWidth() + ", " + r.getHeight() + ")";
        param = String.valueOf(param) + ", start=" + this.start + ", sweep=" + this.sweep;
        return String.valueOf(param) + tail;
    }

    @Override
    protected GRectangle localBounds(GTransform ctm) {
        GRectangle bb = new GRectangle(ctm.transform(this.getArcPoint(this.start)));
        bb.add(ctm.transform(this.getArcPoint(this.start + this.sweep)));
        double rx = this.width / 2.0;
        double ry = this.height / 2.0;
        double a = ctm.getScaleX();
        double b = ctm.getShearY();
        double c = ctm.getShearX();
        double d = ctm.getScaleY();
        double tx = Math.atan2(c * this.height, a * this.width);
        double ty = Math.atan2(d * this.height, b * this.width);
        int i = 0;
        while (i < 4) {
            double t1 = tx + (double)i * Math.PI / 2.0;
            double t2 = ty + (double)i * Math.PI / 2.0;
            if (this.containsAngle(GMath.toDegrees(t1))) {
                bb.add(ctm.transform(rx + rx * Math.cos(t1), ry - ry * Math.sin(t1)));
            }
            if (this.containsAngle(GMath.toDegrees(t2))) {
                bb.add(ctm.transform(rx + rx * Math.cos(t2), ry - ry * Math.sin(t2)));
            }
            ++i;
        }
        if (this.isFilled()) {
            bb.add(ctm.transform(rx, ry));
        }
        return bb;
    }

    @Override
    protected boolean localContains(double x, double y) {
        double rx = this.width / 2.0;
        double ry = this.height / 2.0;
        if (rx == 0.0 || ry == 0.0) {
            return false;
        }
        double dx = x - rx;
        double dy = y - ry;
        double r = dx * dx / (rx * rx) + dy * dy / (ry * ry);
        if (this.isFilled()) {
            if (r > 1.0) {
                return false;
            }
        } else {
            double t = 2.5 / ((rx + ry) / 2.0);
            if (Math.abs(1.0 - r) > t) {
                return false;
            }
        }
        return this.containsAngle(GMath.toDegrees(Math.atan2(-dy, dx)));
    }

    @Override
    protected void paint2d(Graphics2D g) {
        Arc2D.Double arc = new Arc2D.Double(0.0, 0.0, this.width, this.height, this.start, this.sweep, this.isFilled() ? 2 : 0);
        if (this.isFilled()) {
            g.setColor(this.getFillColor());
            g.fill(arc);
            g.setColor(this.getColor());
        }
        g.draw(arc);
    }

    private GPoint getArcPoint(double angle) {
        double rx = this.width / 2.0;
        double ry = this.height / 2.0;
        return new GPoint(rx + rx * GMath.cosDegrees(angle), ry - ry * GMath.sinDegrees(angle));
    }

    private boolean containsAngle(double theta) {
        double start = Math.min(this.getStartAngle(), this.getStartAngle() + this.getSweepAngle());
        double sweep = Math.abs(this.getSweepAngle());
        if (sweep >= 360.0) {
            return true;
        }
        theta = theta < 0.0 ? 360.0 - -theta % 360.0 : theta % 360.0;
        double d = start = start < 0.0 ? 360.0 - -start % 360.0 : start % 360.0;
        if (start + sweep > 360.0) {
            return theta >= start || theta <= start + sweep - 360.0;
        }
        return theta >= start && theta <= start + sweep;
    }
}

