/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.graphics;

import edu.stanford.cs.graphics.GDimension;
import edu.stanford.cs.graphics.GImageTools;
import edu.stanford.cs.graphics.GMath;
import edu.stanford.cs.graphics.GObject;
import edu.stanford.cs.graphics.GRectangle;
import edu.stanford.cs.graphics.GResizable;
import edu.stanford.cs.graphics.GTransform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.io.File;

public class GImage
extends GObject
implements GResizable {
    private Image image;
    private double width;
    private double height;
    private boolean sizeDetermined;

    public GImage(Image image) {
        this(image, 0.0, 0.0);
    }

    public GImage(String name) {
        this(name, 0.0, 0.0);
    }

    public GImage(int[][] array) {
        this(array, 0.0, 0.0);
    }

    public GImage(Image image, double x, double y) {
        this.setImage(image);
        this.setLocation(x, y);
    }

    public GImage(String name, double x, double y) {
        this(GImageTools.loadImage(name), x, y);
    }

    public GImage(int[][] array, double x, double y) {
        this(GImageTools.createImage(array), x, y);
    }

    public void setImage(Image image) {
        this.image = GImageTools.loadImage(image);
        this.sizeDetermined = false;
        this.determineSize();
        this.repaint();
    }

    public void setImage(String name) {
        this.setImage(GImageTools.loadImage(name));
    }

    public Image getImage() {
        return this.image;
    }

    public void saveImage(String filename) {
        GImageTools.saveImage(this.image, filename);
    }

    public void saveImage(File file) {
        GImageTools.saveImage(this.image, file);
    }

    @Override
    public final void setSize(double width, double height) {
        if (this.isTransformed()) {
            throw new RuntimeException("setSize called on transformed object");
        }
        this.width = width;
        this.height = height;
        this.repaint();
    }

    @Override
    public final void setSize(GDimension size) {
        this.setSize(size.getWidth(), size.getHeight());
    }

    @Override
    public void setBounds(double x, double y, double width, double height) {
        if (this.isTransformed()) {
            throw new RuntimeException("setBounds called on transformed object");
        }
        this.width = width;
        this.height = height;
        this.setLocation(x, y);
    }

    @Override
    public final void setBounds(GRectangle bounds) {
        this.setBounds(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    public int[][] getPixelArray() {
        return GImageTools.getPixelArray(this.image);
    }

    public static int getAlpha(int pixel) {
        return pixel >> 24 & 0xFF;
    }

    public static int getRed(int pixel) {
        return pixel >> 16 & 0xFF;
    }

    public static int getGreen(int pixel) {
        return pixel >> 8 & 0xFF;
    }

    public static int getBlue(int pixel) {
        return pixel & 0xFF;
    }

    public static int createRGBPixel(int red, int green, int blue) {
        return GImage.createRGBPixel(red, green, blue, 255);
    }

    public static int createRGBPixel(int red, int green, int blue, int alpha) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    @Override
    protected GRectangle localBounds(GTransform ctm) {
        this.determineSize();
        GRectangle bb = new GRectangle(ctm.transform(0.0, 0.0));
        bb.add(ctm.transform(this.width, 0.0));
        bb.add(ctm.transform(0.0, this.height));
        bb.add(ctm.transform(this.width, this.height));
        return bb;
    }

    @Override
    protected boolean localContains(double x, double y) {
        this.determineSize();
        return x >= 0.0 && x < this.width && y >= 0.0 && y < this.height;
    }

    @Override
    protected void paint2d(Graphics2D g) {
        Component imageObserver = this.getComponent();
        if (imageObserver == null) {
            imageObserver = GImageTools.getImageObserver();
        }
        if (this.image != null && imageObserver != null) {
            this.determineSize();
            Color color = this.getObjectColor();
            if (color == null) {
                g.drawImage(this.image, 0, 0, GMath.round(this.width), GMath.round(this.height), imageObserver);
            } else {
                g.drawImage(this.image, 0, 0, GMath.round(this.width), GMath.round(this.height), color, imageObserver);
            }
        }
    }

    private void determineSize() {
        if (this.sizeDetermined) {
            return;
        }
        Component component = this.getComponent();
        if (component == null) {
            component = GImageTools.getImageObserver();
        }
        this.width = this.image.getWidth(component);
        this.height = this.image.getHeight(component);
        this.sizeDetermined = true;
    }
}

