/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.graphics;

import edu.stanford.cs.graphics.ImageSaver;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import javax.xml.bind.DatatypeConverter;

public class GImageTools {
    public static final String DEFAULT_IMAGE_PATH = ".:images";
    private static boolean cachingEnabled = false;
    private static HashMap<String, Image> imageTable = new HashMap();
    private static HashMap<String, ImageSaver> suffixTable = new HashMap();
    private static Component emptyContainer;

    protected GImageTools() {
    }

    public static Image loadImage(String name) {
        return GImageTools.loadImage(name, DEFAULT_IMAGE_PATH);
    }

    public static Image loadImage(String name, String path) {
        Image image = imageTable.get(name);
        if (image != null) {
            return image;
        }
        if (name.startsWith("data:")) {
            return GImageTools.readDataImage(name);
        }
        if (name.startsWith("http:")) {
            try {
                image = GImageTools.loadImage(new URL(name));
                if (cachingEnabled) {
                    imageTable.put(name, image);
                }
                return image;
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException("loadImage: Malformed URL");
            }
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        StringTokenizer tokenizer = new StringTokenizer(path, ":");
        while (image == null && tokenizer.hasMoreTokens()) {
            String prefix = tokenizer.nextToken();
            prefix = prefix.equals(".") ? "" : String.valueOf(prefix) + "/";
            try {
                if (!new File(String.valueOf(prefix) + name).canRead()) continue;
                image = toolkit.getImage(String.valueOf(prefix) + name);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (image == null) {
            throw new RuntimeException("Cannot find an image named " + name);
        }
        GImageTools.loadImage(image);
        if (cachingEnabled) {
            imageTable.put(name, image);
        }
        return image;
    }

    public static Image loadImage(URL url) {
        return GImageTools.loadImage(url, true);
    }

    public static Image loadImage(Image image) {
        MediaTracker tracker = new MediaTracker(GImageTools.getImageObserver());
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Image loading process interrupted");
        }
        return image;
    }

    public static void defineImage(String name, Image image) {
        imageTable.put(name, image);
    }

    public static void flushImage(String name) {
        imageTable.remove(name);
    }

    public static Image createImage(int[][] array) {
        int height = array.length;
        int width = array[0].length;
        int[] pixels = new int[width * height];
        int i = 0;
        while (i < height) {
            System.arraycopy(array[i], 0, pixels, i * width, width);
            ++i;
        }
        return GImageTools.createImage(pixels, width, height);
    }

    public static Image createImage(int[] pixels, int width, int height) {
        MemoryImageSource source = new MemoryImageSource(width, height, pixels, 0, width);
        Image image = Toolkit.getDefaultToolkit().createImage(source);
        return GImageTools.loadImage(image);
    }

    public static Image createImage(InputStream in) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int ch = in.read();
            while (ch != -1) {
                out.write(ch);
                ch = in.read();
            }
            byte[] array = out.toByteArray();
            Image image = Toolkit.getDefaultToolkit().createImage(array);
            return GImageTools.loadImage(image);
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception: " + ex);
        }
    }

    public static int[][] getPixelArray(Image image) {
        Component observer = GImageTools.getImageObserver();
        int width = image.getWidth(observer);
        int height = image.getHeight(observer);
        int[] pixels = new int[width * height];
        int[][] array = new int[height][width];
        PixelGrabber pg = new PixelGrabber(image.getSource(), 0, 0, width, height, pixels, 0, width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Transfer interrupted");
        }
        if ((pg.getStatus() & 0x80) != 0) {
            throw new RuntimeException("Transfer aborted");
        }
        int i = 0;
        while (i < height) {
            System.arraycopy(pixels, i * width, array[i], 0, width);
            ++i;
        }
        return array;
    }

    public static void saveImage(Image image, String filename) {
        GImageTools.saveImage(image, new File(filename));
    }

    public static void saveImage(Image image, File file) {
        String filename = file.getName();
        int dot = filename.lastIndexOf(46);
        if (dot <= 0) {
            throw new RuntimeException("saveImage: No image suffix in file name");
        }
        String suffix = filename.substring(dot + 1);
        ImageSaver saver = GImageTools.findImageSaver(suffix);
        if (saver == null) {
            throw new RuntimeException("saveImage: No support for ." + suffix + " format");
        }
        if (file.exists() && !file.delete()) {
            throw new RuntimeException("saveImage: Cannot write " + filename);
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            saver.setOutputStream(out);
            saver.saveImage(image);
            ((OutputStream)out).close();
        }
        catch (IOException ex) {
            throw new RuntimeException("saveImage: " + ex.getMessage());
        }
    }

    public static Image loadImage(URL url, boolean topLevel) {
        Image image = null;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            URLConnection connection = url.openConnection();
            if (connection.getContentLength() > 0) {
                Object content = connection.getContent();
                if (content instanceof ImageProducer) {
                    image = toolkit.createImage((ImageProducer)content);
                } else if (content != null) {
                    image = toolkit.getImage(url);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (topLevel) {
            if (image == null) {
                throw new RuntimeException("Cannot load image from " + url);
            }
            GImageTools.loadImage(image);
        }
        return image;
    }

    public static Image readDataImage(String url) {
        int p0 = url.indexOf(",") + 1;
        if (p0 == 0) {
            throw new RuntimeException("Malformed data URL");
        }
        byte[] data = DatatypeConverter.parseBase64Binary((String)url.substring(p0));
        return Toolkit.getDefaultToolkit().createImage(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ImageSaver findImageSaver(String suffix) {
        String cname = GImageTools.class.getName();
        String pkg = cname.substring(0, cname.lastIndexOf("."));
        suffix = suffix.toUpperCase();
        HashMap<String, ImageSaver> hashMap = suffixTable;
        synchronized (hashMap) {
            ImageSaver saver = suffixTable.get(suffix);
            if (saver == null) {
                try {
                    cname = String.valueOf(pkg) + "." + suffix + "ImageSaver";
                    Class<?> imageSaverClass = Class.forName(cname);
                    saver = (ImageSaver)imageSaverClass.newInstance();
                }
                catch (Exception ex) {
                    return null;
                }
                suffixTable.put(suffix, saver);
            }
            return saver;
        }
    }

    public static Component getImageObserver() {
        if (emptyContainer == null) {
            emptyContainer = new JPanel();
        }
        return emptyContainer;
    }
}

