/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.graphics;

import edu.stanford.cs.graphics.GContainer;
import edu.stanford.cs.graphics.GObject;
import java.util.Iterator;

class GIterator
implements Iterator<GObject> {
    private GContainer cont;
    private int dir;
    private int index;
    private int nElements;

    public GIterator(GContainer container, int direction) {
        switch (direction) {
            case 0: 
            case 1: {
                this.dir = direction;
                break;
            }
            default: {
                throw new RuntimeException("Illegal direction for iterator");
            }
        }
        this.cont = container;
        this.index = 0;
        this.nElements = container.getElementCount();
    }

    @Override
    public boolean hasNext() {
        return this.index < this.nElements;
    }

    @Override
    public GObject next() {
        if (this.dir == 1) {
            return this.cont.getElement(this.nElements - this.index++ - 1);
        }
        return this.cont.getElement(this.index++);
    }

    public GObject nextElement() {
        return this.next();
    }

    @Override
    public void remove() {
        if (this.dir == 1) {
            this.cont.remove(this.cont.getElement(this.nElements - --this.index - 1));
        } else {
            this.cont.remove(this.cont.getElement(--this.index));
        }
        --this.nElements;
    }
}

