/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.graphics;

import edu.stanford.cs.graphics.GImageTools;
import edu.stanford.cs.graphics.GObject;
import edu.stanford.cs.graphics.GRectangle;
import edu.stanford.cs.graphics.GTransform;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;

public class GLabel
extends GObject {
    public static final Font DEFAULT_FONT = new Font("Default", 0, 12);
    private String label;
    private Font labelFont;
    private static final Component DUMMY_COMPONENT = GImageTools.getImageObserver();

    public GLabel(String str) {
        this(str, 0.0, 0.0);
    }

    public GLabel(String str, double x, double y) {
        this.label = str;
        this.setFont(DEFAULT_FONT);
        this.setLocation(x, y);
    }

    public void setFont(Font font) {
        this.labelFont = font;
        this.repaint();
    }

    public void setFont(String str) {
        this.setFont(Font.decode(str));
    }

    public Font getFont() {
        return this.labelFont;
    }

    public void setLabel(String str) {
        this.label = str;
        this.repaint();
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    protected void paint2d(Graphics2D g) {
        g.setFont(this.labelFont);
        g.drawString(this.label, 0, 0);
    }

    public double getAscent() {
        return this.getFontMetrics().getAscent();
    }

    public double getDescent() {
        return this.getFontMetrics().getDescent();
    }

    public FontMetrics getFontMetrics() {
        Component comp = this.getComponent();
        if (comp == null) {
            comp = DUMMY_COMPONENT;
        }
        return comp.getFontMetrics(this.labelFont);
    }

    @Override
    public String paramString() {
        return String.valueOf(super.paramString()) + ", string=\"" + this.label + "\"";
    }

    @Override
    protected GRectangle localBounds(GTransform ctm) {
        FontMetrics fm = this.getFontMetrics();
        double y0 = -fm.getAscent();
        double width = fm.stringWidth(this.label);
        double height = fm.getHeight();
        GRectangle bb = new GRectangle(ctm.transform(0.0, y0));
        bb.add(ctm.transform(width, y0));
        bb.add(ctm.transform(0.0, y0 + height));
        bb.add(ctm.transform(width, y0 + height));
        return bb;
    }

    @Override
    protected boolean localContains(double x, double y) {
        FontMetrics fm = this.getFontMetrics();
        double y0 = -fm.getAscent();
        double width = fm.stringWidth(this.label);
        double height = fm.getHeight();
        return x >= 0.0 && x < width && y >= y0 && y < y0 + height;
    }
}

