/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.graphics;

import edu.stanford.cs.graphics.GDimension;
import edu.stanford.cs.graphics.GFillable;
import edu.stanford.cs.graphics.GObject;
import edu.stanford.cs.graphics.GRectangle;
import edu.stanford.cs.graphics.GResizable;
import edu.stanford.cs.graphics.GTransform;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;

public class GOval
extends GObject
implements GFillable,
GResizable {
    private double width;
    private double height;
    private boolean isFilled;
    private Color fillColor;

    public GOval(double width, double height) {
        this(0.0, 0.0, width, height);
    }

    public GOval(double x, double y, double width, double height) {
        this.width = width;
        this.height = height;
        this.setLocation(x, y);
    }

    @Override
    public void setFilled(boolean fill) {
        this.isFilled = fill;
        this.repaint();
    }

    @Override
    public boolean isFilled() {
        return this.isFilled;
    }

    @Override
    public void setFillColor(Color color) {
        this.fillColor = color;
        this.repaint();
    }

    @Override
    public Color getFillColor() {
        return this.fillColor == null ? this.getColor() : this.fillColor;
    }

    @Override
    public final void setSize(double width, double height) {
        if (this.isTransformed()) {
            throw new RuntimeException("setSize called on transformed object");
        }
        this.width = width;
        this.height = height;
        this.repaint();
    }

    @Override
    public final void setSize(GDimension size) {
        this.setSize(size.getWidth(), size.getHeight());
    }

    @Override
    public void setBounds(double x, double y, double width, double height) {
        if (this.isTransformed()) {
            throw new RuntimeException("setBounds called on transformed object");
        }
        this.width = width;
        this.height = height;
        this.setLocation(x, y);
    }

    @Override
    public void setBounds(GRectangle bounds) {
        this.setBounds(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    @Override
    protected GRectangle localBounds(GTransform ctm) {
        double rx = this.width / 2.0;
        double ry = this.height / 2.0;
        double a = ctm.getScaleX();
        double b = ctm.getShearY();
        double c = ctm.getShearX();
        double d = ctm.getScaleY();
        double tx = Math.atan2(c * this.height, a * this.width);
        double ty = Math.atan2(d * this.height, b * this.width);
        GRectangle bb = new GRectangle(ctm.transform(rx, ry));
        int i = 0;
        while (i < 4) {
            double t1 = tx + (double)i * Math.PI / 2.0;
            double t2 = ty + (double)i * Math.PI / 2.0;
            bb.add(ctm.transform(rx + rx * Math.cos(t1), ry - ry * Math.sin(t1)));
            bb.add(ctm.transform(rx + rx * Math.cos(t2), ry - ry * Math.sin(t2)));
            ++i;
        }
        return bb;
    }

    @Override
    protected boolean localContains(double x, double y) {
        double rx = this.width / 2.0;
        double tx = x - rx;
        double ry = this.height / 2.0;
        double ty = y - ry;
        return tx * tx / (rx * rx) + ty * ty / (ry * ry) <= 1.0;
    }

    @Override
    protected void paint2d(Graphics2D g) {
        Ellipse2D.Double oval = new Ellipse2D.Double(0.0, 0.0, this.width, this.height);
        if (this.isFilled()) {
            g.setColor(this.getFillColor());
            g.fill(oval);
            g.setColor(this.getColor());
        }
        g.draw(oval);
    }
}

