/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.graphics;

import edu.stanford.cs.graphics.GRect;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;

public class GRoundRect
extends GRect {
    public static final double DEFAULT_ARC = 10.0;
    private double aWidth;
    private double aHeight;

    public GRoundRect(double width, double height) {
        this(0.0, 0.0, width, height, 10.0);
    }

    public GRoundRect(double x, double y, double width, double height) {
        this(x, y, width, height, 10.0);
    }

    public GRoundRect(double x, double y, double width, double height, double arcSize) {
        this(x, y, width, height, arcSize, arcSize);
    }

    public GRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        super(x, y, width, height);
        this.aWidth = arcWidth;
        this.aHeight = arcHeight;
    }

    public double getArcWidth() {
        return this.aWidth;
    }

    public double getArcHeight() {
        return this.aHeight;
    }

    @Override
    protected void paint2d(Graphics2D g) {
        RoundRectangle2D.Double rr = new RoundRectangle2D.Double(0.0, 0.0, this.getFrameWidth(), this.getFrameHeight(), this.aWidth, this.aHeight);
        if (this.isFilled()) {
            g.setColor(this.getFillColor());
            g.fill(rr);
            g.setColor(this.getColor());
        }
        g.draw(rr);
    }
}

