/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.graphics;

import edu.stanford.cs.graphics.GMath;
import edu.stanford.cs.graphics.GPoint;
import java.util.ArrayList;

class VertexList {
    private ArrayList<GPoint> vertices = new ArrayList();
    private double cx = 0.0;
    private double cy = 0.0;

    public VertexList() {
    }

    public VertexList(VertexList oldList) {
        this();
        int i = 0;
        while (i < oldList.vertices.size()) {
            this.vertices.add(oldList.vertices.get(i));
            ++i;
        }
    }

    public synchronized void addVertex(double x, double y) {
        this.cx = x;
        this.cy = y;
        this.vertices.add(new GPoint(this.cx, this.cy));
    }

    public synchronized void addEdge(double dx, double dy) {
        this.cx += dx;
        this.cy += dy;
        this.vertices.add(new GPoint(this.cx, this.cy));
    }

    public void addArc(double arcWidth, double arcHeight, double start, double sweep) {
        double aspectRatio = arcHeight / arcWidth;
        double rx = arcWidth / 2.0;
        double ry = arcHeight / 2.0;
        double x0 = this.cx - rx * GMath.cosDegrees(start);
        double y0 = this.cy + ry * GMath.sinDegrees(start);
        if (sweep > 359.99) {
            sweep = 360.0;
        }
        if (sweep < -359.99) {
            sweep = -360.0;
        }
        double dt = Math.atan2(1.0, Math.max(arcWidth, arcHeight));
        int nSteps = (int)(GMath.toRadians(Math.abs(sweep)) / dt);
        dt = GMath.toRadians(sweep) / (double)nSteps;
        double theta = GMath.toRadians(start);
        int i = 0;
        while (i < nSteps) {
            double px = x0 + rx * Math.cos(theta += dt);
            double py = y0 - rx * Math.sin(theta) * aspectRatio;
            this.addVertex(px, py);
            ++i;
        }
    }

    public synchronized void add(GPoint[] array) {
        int i = 0;
        while (i < array.length) {
            this.vertices.add(new GPoint(array[i].getX(), array[i].getY()));
            ++i;
        }
    }

    public synchronized void remove(GPoint vertex) {
        this.vertices.remove(vertex);
    }

    public synchronized void clear() {
        this.vertices.clear();
    }

    public int size() {
        return this.vertices.size();
    }

    GPoint get(int index) {
        return this.vertices.get(index);
    }

    public GPoint getCurrentPoint() {
        return this.vertices.size() == 0 ? null : new GPoint(this.cx, this.cy);
    }
}

