/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.sjs;

import edu.stanford.cs.controller.Updater;
import edu.stanford.cs.exp.Expression;
import edu.stanford.cs.java2js.JSEvent;
import edu.stanford.cs.java2js.JSFile;
import edu.stanford.cs.java2js.JSFileChooser;
import edu.stanford.cs.java2js.JSFrame;
import edu.stanford.cs.java2js.JSProgram;
import edu.stanford.cs.jsconsole.JSConsole;
import edu.stanford.cs.parser.CodeVector;
import edu.stanford.cs.sjs.CompileUpdater;
import edu.stanford.cs.sjs.RunUpdater;
import edu.stanford.cs.sjs.SJSApplicationMonitor;
import edu.stanford.cs.sjs.SJSC;
import edu.stanford.cs.sjs.SJSCompiler;
import edu.stanford.cs.sjs.SJSConsoleListener;
import edu.stanford.cs.sjs.SJSControlStrip;
import edu.stanford.cs.sjs.SJSEditor;
import edu.stanford.cs.sjs.SJSEditorListener;
import edu.stanford.cs.sjs.SJSGUI;
import edu.stanford.cs.sjs.SJSInterpreter;
import edu.stanford.cs.sjs.SJSLayout;
import edu.stanford.cs.sjs.SJSLoadListener;
import edu.stanford.cs.sjs.SJSMenuBar;
import edu.stanford.cs.sjs.SJSParser;
import edu.stanford.cs.sjs.SJSReadEvalPrintLoop;
import edu.stanford.cs.sjs.SJSSaveListener;
import edu.stanford.cs.sjs.SJSStateChangeListener;
import edu.stanford.cs.sjs.SJSVM;
import edu.stanford.cs.sjs.SaveUpdater;
import edu.stanford.cs.sjs.StepUpdater;
import edu.stanford.cs.sjslib.core.Package_core;
import edu.stanford.cs.svm.SVM;
import edu.stanford.cs.svm.SVMModule;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class SJS
extends JSProgram {
    private JSConsole console;
    private JSFileChooser chooser;
    private SJSCompiler compiler;
    private SJSControlStrip controlStrip;
    private SJSEditor editor;
    private SJSMenuBar menuBar;
    private SJSParser parser;
    private SJSReadEvalPrintLoop readEvalPrintLoop;
    private SJSVM svm;
    private SVMModule module;
    private String mainFunction;

    public SJS() {
        this.createProgramFrame();
        this.getFrame().setPreferredSize(this.getPreferredSizeForScreen());
        this.setTitle("SJS 1.0.4 (1-May-17)");
        this.setLayout(new SJSLayout());
        this.mainFunction = null;
        this.parser = new SJSParser();
        this.editor = new SJSEditor();
        this.editor.addChangeListener(new SJSEditorListener(this));
        this.svm = new SJSVM(this);
        SJSStateChangeListener listener = new SJSStateChangeListener(this);
        this.svm.addChangeListener(listener);
        this.svm.setFrame(this.getFrame());
        this.svm.setErrorHandler(null);
        this.svm.setTarget(this.svm);
        this.svm.setSpeed(100);
        this.console = new JSConsole();
        this.console.setFont(SJSC.CONSOLE_FONT);
        this.console.addActionListener(new SJSConsoleListener(this));
        this.svm.setConsole(this.console);
        new Package_core().init(this.svm);
        this.chooser = new JSFileChooser(this.getFrame());
        this.chooser.addLoadListener(new SJSLoadListener(this, this.chooser));
        this.chooser.addSaveListener(new SJSSaveListener(this, this.chooser));
        JSFrame consoleFrame = this.createFrame(this.console, "Console");
        JSFrame editorFrame = this.createFrame(this.editor, "Untitled");
        this.editor.setFrame(editorFrame);
        SJSApplicationMonitor monitor = new SJSApplicationMonitor(this);
        this.compiler = new SJSCompiler(this.svm, this.parser, monitor);
        this.readEvalPrintLoop = new SJSReadEvalPrintLoop(this.svm, this.parser, monitor);
        this.controlStrip = new SJSControlStrip(this);
        this.menuBar = new SJSMenuBar(this);
        this.setMenuBar(this.menuBar);
        this.add(consoleFrame, "console");
        this.add(editorFrame, "editor");
        this.setBackground(SJSC.APPLICATION_BACKGROUND);
        this.updateControls();
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void run() {
        this.updateChooser();
        this.getCommand();
    }

    public void updateChooser() {
        if (JSProgram.isJavaScript()) {
            String path = "cgi:" + this.getUID() + "/SJS";
            this.chooser.setCurrentDirectory(path);
        } else {
            this.chooser.setCurrentDirectory("examples");
        }
    }

    public void getCommand() {
        this.console.requestInput("> ");
    }

    public void signalFinished() {
        if (this.svm.isFinished()) {
            this.getCommand();
        }
    }

    public void statementHook(int offset) {
        int line = this.editor.getSourceLineIndex(offset);
        if (line > 0 && this.editor.isBreakpoint(line)) {
            this.svm.setState(4);
        }
    }

    public void showLoadDialog() {
        this.chooser.setDialogTitle("Load");
        this.chooser.showLoadDialog();
    }

    public void showSaveDialog() {
        this.chooser.setDialogTitle("Save");
        JSFile file = this.editor.getFile();
        if (file != null) {
            file.write(this.editor.getText(), null);
        } else {
            this.chooser.showSaveDialog();
        }
    }

    public void showExportDialog() {
        this.chooser.setDialogTitle("Export");
        String path = this.chooser.getPath();
        if (path != null) {
            this.chooser.setPath(JSFile.getRoot(path));
        }
        this.chooser.showSaveDialog();
    }

    public void newFileCommand() {
        this.editor.setFile(null);
        this.editor.setText("");
        this.editor.clearOffsetTable();
        this.editor.repaint();
    }

    public void updateControls() {
        this.controlStrip.update();
        this.menuBar.update();
    }

    public void processConsoleLine(String line) {
        this.readEvalPrintLoop.processConsoleLine(line);
    }

    public Updater createSaveUpdater() {
        return new SaveUpdater(this);
    }

    public boolean isSaveEnabled() {
        return this.editor.getFile() == null || this.editor.isSaveNeeded();
    }

    public Updater createRunUpdater() {
        return new RunUpdater(this);
    }

    public boolean isRunEnabled() {
        return !this.svm.isRunning() && this.getMainFunction() != null && !this.editor.isParseNeeded();
    }

    public Updater createCompileUpdater() {
        return new CompileUpdater(this);
    }

    public boolean isCompileEnabled() {
        return this.editor.isParseNeeded();
    }

    public Updater createStepUpdater() {
        return new StepUpdater(this);
    }

    public boolean isStepEnabled() {
        return !this.svm.isRunning() && this.getMainFunction() != null && !this.editor.isParseNeeded();
    }

    public void showError(String msg, int line) {
        this.editor.showErrorDialog(msg, line);
    }

    public SVM getSVM() {
        return this.svm;
    }

    public SVMModule getModule() {
        return this.module;
    }

    public JSConsole getConsole() {
        return this.console;
    }

    public SJSEditor getEditor() {
        return this.editor;
    }

    public SJSParser getParser() {
        return this.parser;
    }

    public SJSControlStrip getControlStrip() {
        return this.controlStrip;
    }

    public void setTraceFlag(boolean flag) {
        this.svm.setTraceFlag(flag);
    }

    public boolean getTraceFlag() {
        return this.svm.getTraceFlag();
    }

    public String getMainFunction() {
        return this.svm.isGlobal("main") ? "main" : this.mainFunction;
    }

    public void parseProgram() {
        try {
            String pathname = "Untitled";
            if (this.editor.getFile() != null) {
                pathname = this.editor.getFile().getPath();
            }
            String text = this.editor.getText();
            this.svm.setSource(text);
            this.parser.setInput(text);
            this.module = this.parser.readModule(pathname);
            this.module.setSourceText(text);
            CodeVector cv = this.compiler.executeModule(pathname, this.module);
            this.editor.addBreakpointLines(cv.getCode());
            boolean first = true;
            for (Expression fn : this.module.getFunctions()) {
                String name = fn.getArgs()[0].getName();
                if (!first || name.indexOf("#") != -1) continue;
                this.mainFunction = name;
                first = false;
            }
            for (String name : this.module.getImports()) {
                if (name.indexOf(".") == -1) continue;
                this.compileSourceLibrary(JSFile.getHead(pathname), name);
            }
            this.editor.setParseNeeded(false);
        }
        catch (RuntimeException ex) {
            int line = this.editor.getLineNumber(this.parser.getPosition());
            this.editor.showErrorDialog(ex.getMessage(), line);
        }
        this.updateControls();
    }

    public void compileSourceLibrary(String base, String filename) {
        try {
            String line;
            String pathname = String.valueOf(base) + "/" + filename;
            BufferedReader rd = new BufferedReader(new FileReader(pathname));
            String text = "";
            while ((line = rd.readLine()) != null) {
                text = String.valueOf(text) + line + "\n";
            }
            rd.close();
            this.svm.setSource(text);
            this.parser.setInput(text);
            SVMModule module = this.parser.readModule(pathname);
            this.compiler.executeModule(pathname, module);
            for (String name : module.getImports()) {
                if (name.indexOf(".") == -1) continue;
                this.compileSourceLibrary(JSFile.getHead(pathname), name);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("No source library named " + filename);
        }
    }

    private Dimension getPreferredSizeForScreen() {
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        int width = Math.min(1200, (int)size.getWidth() - 20);
        int height = Math.min(800, (int)size.getHeight() - 60);
        return new Dimension(width, height);
    }

    private JSFrame createFrame(JComponent component, String title) {
        return new JSFrame(component, title);
    }

    public static void main(String[] args) {
        JSEvent.setHeadlessTimer(true);
        boolean hasArgs = false;
        boolean trace = false;
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.startsWith("code=")) break;
            if (arg.startsWith("-")) {
                if (arg.equals("-t")) {
                    trace = true;
                } else {
                    hasArgs = true;
                }
            } else {
                hasArgs = true;
            }
            ++i;
        }
        if (hasArgs) {
            new SJSInterpreter().start(args);
        } else {
            JSEvent.setHeadlessTimer(false);
            SwingUtilities.invokeLater(new SJSGUI(trace));
        }
    }
}

