/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.sjs;

import edu.stanford.cs.exp.Constant;
import edu.stanford.cs.exp.Expression;
import edu.stanford.cs.exp.Value;
import edu.stanford.cs.parser.CodeVector;
import edu.stanford.cs.parser.Operator;
import edu.stanford.cs.parser.Parser;
import edu.stanford.cs.parser.SyntaxError;
import java.util.ArrayList;

public class SJSBraceOperator
extends Operator {
    @Override
    public Expression prefixAction(Parser p) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        String name = p.nextToken();
        if (!name.equals("}")) {
            while (true) {
                switch (p.getTokenType(name)) {
                    case 3: {
                        name = p.getTokenScanner().getStringValue(name);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        throw new SyntaxError("Illegal field name");
                    }
                }
                p.verifyToken(":");
                Expression exp = p.readE(0);
                list.add(new Constant(Value.createString(name)));
                list.add(exp);
                String token = p.nextToken();
                if (token.equals("}")) break;
                if (!token.equals(",")) {
                    throw new SyntaxError("Found " + p.markCode(token) + " when expecting " + p.markCode(",") + " or " + p.markCode("}"));
                }
                name = p.nextToken();
            }
        }
        Expression[] args = new Expression[list.size()];
        int i = 0;
        while (i < args.length) {
            args[i] = (Expression)list.get(i);
            ++i;
        }
        return p.createCompound(this, args);
    }

    @Override
    public void compile(Parser p, Expression[] args, CodeVector cv) {
        int i = 0;
        while (i < args.length) {
            p.compile(args[i], cv);
            ++i;
        }
        cv.addInstruction(97, cv.stringRef("Object.create"));
        cv.addInstruction(106, args.length);
    }

    @Override
    public String unparse(Parser p, Expression[] args) {
        return "{" + p.unparse(args[0]) + "}";
    }
}

