/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.sjs;

import edu.stanford.cs.exp.Expression;
import edu.stanford.cs.parser.CodeVector;
import edu.stanford.cs.sjs.SJSCommandMonitor;
import edu.stanford.cs.sjs.SJSParser;
import edu.stanford.cs.sjs.SJSVM;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SJSReadEvalPrintLoop
implements ChangeListener {
    private SJSCommandMonitor monitor;
    private SJSParser parser;
    private SJSVM svm;

    public SJSReadEvalPrintLoop(SJSVM svm, SJSParser parser, SJSCommandMonitor monitor) {
        this.svm = svm;
        this.parser = parser;
        this.monitor = monitor;
        svm.addChangeListener(this);
    }

    public void processConsoleLine(String line) {
        try {
            this.parser.setInput(line);
            boolean debug = false;
            String token = this.parser.nextToken();
            if (token.equals("debug")) {
                debug = true;
            } else {
                this.parser.saveToken(token);
            }
            Expression exp = this.parser.readE(0);
            token = this.parser.nextToken();
            boolean showResult = true;
            if (token.equals(";")) {
                showResult = false;
            } else {
                this.parser.saveToken(token);
            }
            this.parser.verifyToken("");
            CodeVector cv = new CodeVector();
            this.parser.compile(exp, cv);
            if (showResult) {
                cv.addInstruction(97, cv.stringRef("Console.$display"));
                cv.addInstruction(106, 1);
            }
            cv.addInstruction(4, 0);
            this.svm.reset();
            this.svm.clearAllTimers();
            this.svm.closeAllGWindows();
            this.svm.setCode(cv.getCode());
            this.svm.setPC(0);
            this.svm.pushExceptionFrame(-999);
            this.svm.start(debug ? 2 : 1);
        }
        catch (Exception ex) {
            String msg = ex.getMessage();
            if (msg == null || msg.equals("")) {
                msg = "" + ex;
            }
            this.monitor.showError(msg, 0);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        switch (this.svm.getState()) {
            case 7: {
                this.monitor.showError(this.svm.getErrorMessage(), 0);
                break;
            }
            case 5: {
                this.monitor.signalFinished();
            }
        }
        this.monitor.update();
    }
}

