/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.sjs;

import edu.stanford.cs.graphics.GWindow;
import edu.stanford.cs.java2js.JSFrame;
import edu.stanford.cs.sjs.SJS;
import edu.stanford.cs.sjs.SJSGWindow;
import edu.stanford.cs.svm.SVM;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.Timer;

public class SJSVM
extends SVM {
    private ArrayList<SJSGWindow> windows;
    private SJS app;
    private JFrame frame;
    private JSFrame embeddedFrame;
    private SJSGWindow embeddedGWindow;
    private HashMap<Integer, Timer> timers;

    public SJSVM(SJS app) {
        this.app = app;
        this.setTarget(this);
        this.setStepMode(1);
        this.frame = null;
        this.embeddedFrame = null;
        this.embeddedGWindow = null;
        this.timers = new HashMap();
        this.windows = new ArrayList();
    }

    public void setFrame(JFrame frame) {
        this.frame = frame;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public int addTimer(Timer timer) {
        int id = this.getFirstFreeId();
        this.timers.put(id, timer);
        return id;
    }

    public void clearTimer(int id) {
        Timer timer = this.timers.get(id);
        if (timer == null) {
            throw new RuntimeException("Illegal timer id");
        }
        timer.stop();
        this.timers.remove(id);
    }

    public void removeTimer(Timer timer) {
        for (int id : this.timers.keySet()) {
            if (this.timers.get(id) != timer) continue;
            this.timers.remove(id);
            return;
        }
    }

    public boolean timersActive() {
        return !this.timers.isEmpty();
    }

    public void clearAllTimers() {
        for (int id : this.timers.keySet()) {
            Timer timer = this.timers.get(id);
            timer.stop();
        }
        this.timers.clear();
    }

    public SJSGWindow createGWindow(double width, double height) {
        SJSGWindow window = new SJSGWindow(this);
        if (width <= 500.0 && height <= 300.0) {
            this.embeddedGWindow = window;
            window.createJSFrame(width, height);
            this.embeddedFrame = window.getJSFrame();
            this.frame.add((Component)this.embeddedFrame, "gwindow");
            this.frame.validate();
        } else {
            window.createFrame(width, height);
        }
        this.windows.add(window);
        return window;
    }

    public void closeGWindow(SJSGWindow window) {
        this.closeOneGWindow(window);
        this.windows.remove(window);
        if (this.getState() == 5 && this.app != null) {
            this.app.signalFinished();
        }
    }

    public void closeAllGWindows() {
        for (SJSGWindow window : this.windows) {
            this.closeOneGWindow(window);
        }
        this.windows.clear();
        this.embeddedGWindow = null;
    }

    public boolean hasOpenFrames() {
        for (SJSGWindow window : this.windows) {
            if (window.getFrame() == null) continue;
            return true;
        }
        return false;
    }

    public boolean isFinished() {
        if (this.timersActive() || this.hasOpenFrames()) {
            return false;
        }
        if (this.embeddedGWindow == null) {
            return true;
        }
        return !this.embeddedGWindow.hasActiveListeners();
    }

    @Override
    protected void stepHook() {
        if (this.app != null) {
            this.app.statementHook(this.getStatementOffset());
        }
    }

    private void closeOneGWindow(SJSGWindow window) {
        GWindow gw = window.getFrame();
        if (gw == null) {
            this.frame.remove(window.getJSFrame());
            this.frame.validate();
        } else {
            gw.setVisible(false);
            this.embeddedGWindow = null;
        }
    }

    private int getFirstFreeId() {
        int id = 1;
        while (this.timers.containsKey(id)) {
            ++id;
        }
        return id;
    }
}

