/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.sjslib.graphics;

import edu.stanford.cs.exp.Value;
import edu.stanford.cs.graphics.GImage;
import edu.stanford.cs.sjslib.graphics.GImageMethod;
import edu.stanford.cs.svm.SVM;

class GImage_xeq
extends GImageMethod {
    GImage_xeq() {
    }

    @Override
    public void execute(SVM svm, Value receiver) {
        svm.checkSignature("GImage.xeq", "*");
        GImage image = (GImage)svm.pop().getValue();
        int[][] array = image.getPixelArray();
        int height = array.length;
        int width = array[0].length;
        int n = width * height;
        int[] histogram = new int[256];
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                int xx = this.computeLuminosity(array[i][j]);
                histogram[xx] = histogram[xx] + 1;
                ++j;
            }
            ++i;
        }
        int total = 0;
        int i2 = 0;
        while (i2 < 256) {
            histogram[i2] = total += histogram[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < height) {
            int j = 0;
            while (j < width) {
                int xx = this.computeLuminosity(array[i2][j]);
                double fraction = (double)histogram[xx] / (double)n;
                xx = (int)(255.0 * fraction + 0.5);
                array[i2][j] = GImage.createRGBPixel(xx, xx, xx);
                ++j;
            }
            ++i2;
        }
        svm.push(Value.createObject(new GImage(array), "GImage"));
    }

    private int computeLuminosity(int pixel) {
        int r = GImage.getRed(pixel);
        int g = GImage.getGreen(pixel);
        int b = GImage.getBlue(pixel);
        return (int)Math.floor(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b + 0.5);
    }
}

