/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.sjslib.util;

import edu.stanford.cs.exp.Value;

class Grid {
    private Value[] elements;
    private int nRows;
    private int nCols;

    public Grid(int nRows, int nCols) {
        this.resize(nRows, nCols);
    }

    public int numRows() {
        return this.nRows;
    }

    public int numCols() {
        return this.nCols;
    }

    public void resize(int nRows, int nCols) {
        if (nRows < 0 || nCols < 0) {
            throw new RuntimeException("Illegal grid size");
        }
        this.nRows = nRows;
        this.nCols = nCols;
        this.elements = new Value[nRows * nCols];
    }

    public boolean inBounds(int row, int col) {
        return row >= 0 && col >= 0 && row < this.nRows && col < this.nCols;
    }

    public Value get(int row, int col) {
        if (!this.inBounds(row, col)) {
            throw new RuntimeException("get: Grid indices out of bounds");
        }
        return this.elements[row * this.nCols + col];
    }

    public void set(int row, int col, Value value) {
        if (!this.inBounds(row, col)) {
            throw new RuntimeException("set: Grid indices out of bounds");
        }
        this.elements[row * this.nCols + col] = value;
    }

    public String toString() {
        String str = "";
        int i = 0;
        while (i < this.nRows) {
            if (i > 0) {
                str = String.valueOf(str) + ", ";
            }
            str = String.valueOf(str) + "{";
            int j = 0;
            while (j < this.nCols) {
                if (j > 0) {
                    str = String.valueOf(str) + ", ";
                }
                str = String.valueOf(str) + this.get(i, j).toString();
                ++j;
            }
            str = String.valueOf(str) + "}";
            ++i;
        }
        return "{" + str + "}";
    }
}

