/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.svm;

import edu.stanford.cs.parser.CodeVector;
import edu.stanford.cs.svm.ADD_Ins;
import edu.stanford.cs.svm.AND_Ins;
import edu.stanford.cs.svm.ARG_Ins;
import edu.stanford.cs.svm.ASH_Ins;
import edu.stanford.cs.svm.CALLFN_Ins;
import edu.stanford.cs.svm.CALLM_Ins;
import edu.stanford.cs.svm.CALL_Ins;
import edu.stanford.cs.svm.DISPATCH_Ins;
import edu.stanford.cs.svm.DIV_Ins;
import edu.stanford.cs.svm.DUP_Ins;
import edu.stanford.cs.svm.ENDTRY_Ins;
import edu.stanford.cs.svm.END_Ins;
import edu.stanford.cs.svm.EQ_Ins;
import edu.stanford.cs.svm.FLUSH_Ins;
import edu.stanford.cs.svm.GE_Ins;
import edu.stanford.cs.svm.GT_Ins;
import edu.stanford.cs.svm.HALT_Ins;
import edu.stanford.cs.svm.IDIV_Ins;
import edu.stanford.cs.svm.JUMPF_Ins;
import edu.stanford.cs.svm.JUMPT_Ins;
import edu.stanford.cs.svm.JUMP_Ins;
import edu.stanford.cs.svm.LE_Ins;
import edu.stanford.cs.svm.LOCALS_Ins;
import edu.stanford.cs.svm.LSH_Ins;
import edu.stanford.cs.svm.LT_Ins;
import edu.stanford.cs.svm.MUL_Ins;
import edu.stanford.cs.svm.NARGS_Ins;
import edu.stanford.cs.svm.NEG_Ins;
import edu.stanford.cs.svm.NE_Ins;
import edu.stanford.cs.svm.NOT_Ins;
import edu.stanford.cs.svm.OR_Ins;
import edu.stanford.cs.svm.PARAMS_Ins;
import edu.stanford.cs.svm.POPLOC_Ins;
import edu.stanford.cs.svm.POPVAR_Ins;
import edu.stanford.cs.svm.PSTACK_Ins;
import edu.stanford.cs.svm.PUSHFN_Ins;
import edu.stanford.cs.svm.PUSHINT_Ins;
import edu.stanford.cs.svm.PUSHLOC_Ins;
import edu.stanford.cs.svm.PUSHNUM_Ins;
import edu.stanford.cs.svm.PUSHSTR_Ins;
import edu.stanford.cs.svm.PUSHVAR_Ins;
import edu.stanford.cs.svm.REM_Ins;
import edu.stanford.cs.svm.RETURN_Ins;
import edu.stanford.cs.svm.ROLL_Ins;
import edu.stanford.cs.svm.STMT_Ins;
import edu.stanford.cs.svm.SUB_Ins;
import edu.stanford.cs.svm.SVM;
import edu.stanford.cs.svm.THROW_Ins;
import edu.stanford.cs.svm.TRY_Ins;
import edu.stanford.cs.svm.VARGS_Ins;
import edu.stanford.cs.svm.VAR_Ins;
import edu.stanford.cs.svm.VERSION_Ins;
import edu.stanford.cs.svm.XOR_Ins;
import edu.stanford.cs.tokenscanner.TokenScanner;
import java.util.TreeMap;

public abstract class SVMInstruction {
    private static TreeMap<String, SVMInstruction> instructionTable = null;
    private static TreeMap<Integer, SVMInstruction> codeTable = null;
    private String name;
    private int code;

    public SVMInstruction(String name, int code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public int getCode() {
        return this.code;
    }

    public void execute(SVM svm, int addr) {
        throw new RuntimeException("Not yet implemented");
    }

    public String unparse(SVM svm, int addr) {
        return this.name;
    }

    public void assemble(CodeVector cv, TokenScanner scanner) {
        cv.addWord(this.code << 24);
    }

    public static SVMInstruction lookup(String name) {
        if (instructionTable == null) {
            SVMInstruction.initializeInstructionTable();
        }
        return instructionTable.get(name);
    }

    public static SVMInstruction get(int code) {
        if (instructionTable == null) {
            SVMInstruction.initializeInstructionTable();
        }
        return codeTable.get(code);
    }

    private static void initializeInstructionTable() {
        instructionTable = new TreeMap();
        codeTable = new TreeMap();
        SVMInstruction.define(new END_Ins());
        SVMInstruction.define(new VERSION_Ins());
        SVMInstruction.define(new PSTACK_Ins());
        SVMInstruction.define(new STMT_Ins());
        SVMInstruction.define(new HALT_Ins());
        SVMInstruction.define(new PUSHINT_Ins());
        SVMInstruction.define(new PUSHNUM_Ins());
        SVMInstruction.define(new PUSHSTR_Ins());
        SVMInstruction.define(new PUSHFN_Ins());
        SVMInstruction.define(new FLUSH_Ins());
        SVMInstruction.define(new DUP_Ins());
        SVMInstruction.define(new ROLL_Ins());
        SVMInstruction.define(new ADD_Ins());
        SVMInstruction.define(new SUB_Ins());
        SVMInstruction.define(new MUL_Ins());
        SVMInstruction.define(new DIV_Ins());
        SVMInstruction.define(new IDIV_Ins());
        SVMInstruction.define(new REM_Ins());
        SVMInstruction.define(new NEG_Ins());
        SVMInstruction.define(new EQ_Ins());
        SVMInstruction.define(new NE_Ins());
        SVMInstruction.define(new LT_Ins());
        SVMInstruction.define(new LE_Ins());
        SVMInstruction.define(new GT_Ins());
        SVMInstruction.define(new GE_Ins());
        SVMInstruction.define(new JUMP_Ins());
        SVMInstruction.define(new JUMPT_Ins());
        SVMInstruction.define(new JUMPF_Ins());
        SVMInstruction.define(new DISPATCH_Ins());
        SVMInstruction.define(new TRY_Ins());
        SVMInstruction.define(new ENDTRY_Ins());
        SVMInstruction.define(new THROW_Ins());
        SVMInstruction.define(new NOT_Ins());
        SVMInstruction.define(new AND_Ins());
        SVMInstruction.define(new OR_Ins());
        SVMInstruction.define(new XOR_Ins());
        SVMInstruction.define(new LSH_Ins());
        SVMInstruction.define(new ASH_Ins());
        SVMInstruction.define(new CALL_Ins());
        SVMInstruction.define(new CALLM_Ins());
        SVMInstruction.define(new CALLFN_Ins());
        SVMInstruction.define(new RETURN_Ins());
        SVMInstruction.define(new LOCALS_Ins());
        SVMInstruction.define(new PUSHLOC_Ins());
        SVMInstruction.define(new POPLOC_Ins());
        SVMInstruction.define(new ARG_Ins());
        SVMInstruction.define(new VAR_Ins());
        SVMInstruction.define(new PARAMS_Ins());
        SVMInstruction.define(new NARGS_Ins());
        SVMInstruction.define(new VARGS_Ins());
        SVMInstruction.define(new PUSHVAR_Ins());
        SVMInstruction.define(new POPVAR_Ins());
    }

    private static void define(SVMInstruction ins) {
        instructionTable.put(ins.getName(), ins);
        codeTable.put(ins.getCode(), ins);
    }
}

