/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.controller;

import edu.stanford.cs.controller.Controller;
import edu.stanford.cs.controller.Steppable;

class ControllerStepper
implements Runnable {
    private Controller controller;
    private Steppable target;

    public ControllerStepper(Controller controller, Steppable target) {
        this.controller = controller;
        this.target = target;
    }

    @Override
    public void run() {
        try {
            int oldState = this.controller.getControllerState();
            int nCycles = this.controller.getCycleCount();
            this.target.step();
            while (this.controller.shouldKeepRunning() && --nCycles > 0) {
                this.target.step();
            }
            this.controller.stepComplete(oldState);
        }
        catch (Exception ex) {
            String msg = ex instanceof RuntimeException ? ex.getMessage() : ex.toString();
            this.controller.signalError(msg);
        }
    }
}

