/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.direction;

import java.awt.Point;

public class Direction {
    public static final int NORTH = 0;
    public static final int EAST = 1;
    public static final int SOUTH = 2;
    public static final int WEST = 3;

    public static String directionName(int dir) {
        switch (dir) {
            case 0: {
                return "NORTH";
            }
            case 1: {
                return "EAST";
            }
            case 2: {
                return "SOUTH";
            }
            case 3: {
                return "WEST";
            }
        }
        return null;
    }

    public static int leftFrom(int dir) {
        switch (dir) {
            case 0: {
                return 3;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        throw new RuntimeException("Illegal direction");
    }

    public static int rightFrom(int dir) {
        switch (dir) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 0;
            }
        }
        throw new RuntimeException("Illegal direction");
    }

    public static int oppositeDirection(int dir) {
        switch (dir) {
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
        }
        throw new RuntimeException("Illegal direction");
    }

    public static Point adjacentPoint(Point pt, int dir) {
        switch (dir) {
            case 0: {
                return new Point(pt.x, pt.y + 1);
            }
            case 1: {
                return new Point(pt.x + 1, pt.y);
            }
            case 2: {
                return new Point(pt.x, pt.y - 1);
            }
            case 3: {
                return new Point(pt.x - 1, pt.y);
            }
        }
        throw new RuntimeException("Illegal direction");
    }

    public static double getRotationAngle(int dir) {
        switch (dir) {
            case 1: {
                return 0.0;
            }
            case 0: {
                return 1.5707963267948966;
            }
            case 3: {
                return Math.PI;
            }
            case 2: {
                return 4.71238898038469;
            }
        }
        throw new RuntimeException("Illegal direction");
    }
}

