/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.jscontrols;

import edu.stanford.cs.jscontrols.JSControl;
import edu.stanford.cs.jscontrols.SpeedControlListener;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;

public class SpeedControl
extends JSControl
implements Adjustable {
    private static final String CONTROL = "data:image/png;base64,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";
    private static final String DISABLED = "data:image/png;base64,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";
    private static final Color NEEDLE_COLOR = Color.WHITE;
    private static final int LONG_DELTA = 18;
    private static final int SHORT_DELTA = 4;
    private ArrayList<AdjustmentListener> listeners;
    private SpeedControlListener scl;
    private int speed;

    public SpeedControl() {
        this.setName("Speed");
        this.listeners = new ArrayList();
        this.setIcon(this.createImageIcon(CONTROL));
        this.setDisabledIcon(this.createImageIcon(DISABLED));
        this.setRolloverIcon(this.createImageIcon(CONTROL));
        this.setPressedIcon(this.createImageIcon(CONTROL));
        this.setSpeed(50);
        this.addMouseMotionListener(this.scl);
    }

    public void setSpeed(int speed) {
        this.setValue(speed);
    }

    public int getSpeed() {
        return this.getValue();
    }

    @Override
    public void addAdjustmentListener(AdjustmentListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeAdjustmentListener(AdjustmentListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public int getBlockIncrement() {
        return 10;
    }

    @Override
    public int getMaximum() {
        return 100;
    }

    @Override
    public int getMinimum() {
        return 0;
    }

    @Override
    public int getOrientation() {
        throw new RuntimeException("Illegal call to getOrientation");
    }

    @Override
    public int getUnitIncrement() {
        return 1;
    }

    @Override
    public int getValue() {
        return this.speed;
    }

    @Override
    public int getVisibleAmount() {
        return 100;
    }

    @Override
    public void setBlockIncrement(int dummy) {
        throw new RuntimeException("Illegal call to setBlockIncrement");
    }

    @Override
    public void setMaximum(int dummy) {
        throw new RuntimeException("Illegal call to setMaximum");
    }

    @Override
    public void setMinimum(int dummy) {
        throw new RuntimeException("Illegal call to setMinimum");
    }

    @Override
    public void setUnitIncrement(int dummy) {
        throw new RuntimeException("Illegal call to setUnitIncrement");
    }

    @Override
    public void setValue(int speed) {
        this.speed = speed;
        this.fireAdjustmentListeners();
    }

    @Override
    public void setVisibleAmount(int dummy) {
        throw new RuntimeException("Illegal call to setVisibleAmount");
    }

    public void fireAdjustmentListeners() {
        AdjustmentEvent e = new AdjustmentEvent(this, 601, 5, 0);
        for (AdjustmentListener listener : this.listeners) {
            listener.adjustmentValueChanged(e);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.translate(24, 24);
        g2.rotate(Math.toRadians((double)(this.speed - 50) * 2.7));
        Polygon poly = new Polygon();
        poly.addPoint(0, 4);
        poly.addPoint(4, 0);
        poly.addPoint(0, -18);
        poly.addPoint(-4, 0);
        g2.setColor(NEEDLE_COLOR);
        g2.fillPolygon(poly);
        g2.drawPolygon(poly);
        g2.dispose();
    }

    @Override
    protected MouseListener createMouseListener() {
        this.scl = new SpeedControlListener(this);
        return this.scl;
    }
}

