/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.jseditor;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class LineHighlighter
extends DefaultHighlighter {
    private JTextComponent comp;

    @Override
    public void install(JTextComponent comp) {
        super.install(comp);
        this.comp = comp;
    }

    @Override
    public void deinstall(JTextComponent comp) {
        super.deinstall(comp);
        comp = null;
    }

    @Override
    public void paint(Graphics g) {
        Highlighter.Highlight[] highlights = this.getHighlights();
        int n = highlights.length;
        Rectangle r = this.comp.getBounds();
        Insets insets = this.comp.getInsets();
        r.x = insets.left;
        r.y = insets.top;
        r.height -= insets.top + insets.bottom;
        int i = 0;
        while (i < n) {
            Highlighter.Highlight h = highlights[i];
            String className = h.getClass().getName();
            if (className.indexOf("LayeredHighlightInfo") != -1) {
                Highlighter.HighlightPainter painter = h.getPainter();
                painter.paint(g, h.getStartOffset(), h.getEndOffset(), r, this.comp);
            }
            ++i;
        }
    }
}

