/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.jskarel;

import edu.stanford.cs.jskarel.Karel;
import edu.stanford.cs.jskarel.KarelGraphics;
import edu.stanford.cs.jskarel.KarelWorld;
import edu.stanford.cs.jskarel.KarelWorldEditor;
import edu.stanford.cs.jskarel.MapTool;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;

class BeeperTool
extends MapTool {
    private int nBeepers;

    public BeeperTool(int x, int y, int nBeepers) {
        super(x, y, 22, 22);
        this.nBeepers = nBeepers;
    }

    @Override
    public void paint(Graphics g, KarelWorldEditor editor) {
        Graphics2D g2 = (Graphics2D)g.create();
        Rectangle r = this.getBounds();
        int cx = r.x + r.width / 2;
        int cy = r.y + r.height / 2;
        String label = "" + this.nBeepers;
        switch (this.nBeepers) {
            case 1: {
                label = "";
                break;
            }
            case -1: {
                label = "+1";
                break;
            }
            case -2: {
                label = "-1";
                break;
            }
            case 99999999: {
                label = "\u221e";
            }
        }
        this.setBorderGraphics(g2, editor.getSelectedTool() == this);
        KarelGraphics.drawBeeper(g2, cx, cy, 22, null, label);
        g2.dispose();
    }

    @Override
    public void cornerAction(KarelWorldEditor editor, int x, int y) {
        KarelWorld world = editor.getWorld();
        int nb = world.getBeepersOnCorner(x, y);
        switch (this.nBeepers) {
            case -1: {
                nb = KarelWorld.adjustBeepers(nb, 1);
                break;
            }
            case -2: {
                nb = KarelWorld.adjustBeepers(nb, -1);
                break;
            }
            default: {
                nb = this.nBeepers;
            }
        }
        world.setBeepersOnCorner(x, y, nb);
        editor.getView().repaint();
    }

    @Override
    public void beeperBagAction(KarelWorldEditor editor) {
        Karel karel = editor.getWorld().getKarel();
        int nb = karel.getBeepersInBag();
        switch (this.nBeepers) {
            case -1: {
                nb = KarelWorld.adjustBeepers(nb, 1);
                break;
            }
            case -2: {
                nb = KarelWorld.adjustBeepers(nb, -1);
                break;
            }
            default: {
                nb = this.nBeepers;
            }
        }
        karel.setBeepersInBag(nb);
        editor.repaint();
    }
}

