/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.jskarel;

import edu.stanford.cs.jskarel.KarelWorldEditor;
import edu.stanford.cs.jskarel.MapTool;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;

class ColorTool
extends MapTool {
    private Color color;

    public ColorTool(int x, int y, Color color) {
        super(x, y, 12, 12);
        this.color = color;
    }

    @Override
    public void paint(Graphics g, KarelWorldEditor editor) {
        Graphics2D g2 = (Graphics2D)g.create();
        Rectangle r = this.getBounds();
        if (this.color != null) {
            g2.setColor(this.color);
            g2.fillRect(r.x, r.y, 12, 12);
        }
        this.setBorderGraphics(g2, editor.getSelectedTool() == this);
        g2.drawRect(r.x, r.y, 12, 12);
    }

    @Override
    public void cornerAction(KarelWorldEditor editor, int x, int y) {
        editor.getWorld().setCornerColor(x, y, this.color);
    }
}

