/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.jskarel;

import edu.stanford.cs.direction.Direction;
import edu.stanford.cs.jskarel.KC;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;

public class KarelGraphics {
    private static final BasicStroke NORMAL_WALL = new BasicStroke(2.0f, 2, 0);

    public static void drawBeeper(Graphics g, int x, int y, int size, Color bg, String label) {
        Graphics2D g2 = (Graphics2D)g.create();
        Color fg = g2.getColor();
        int ps = (int)Math.round((double)size * 0.5);
        if ((ps = Math.min(ps, 20)) < 6) {
            ps = 0;
        }
        Polygon p = new Polygon();
        p.addPoint(x - size / 2, y);
        p.addPoint(x, y + size / 2);
        p.addPoint(x + size / 2, y);
        p.addPoint(x, y - size / 2);
        p.addPoint(x - size / 2, y);
        g2.setColor(bg == null ? KC.BEEPER_FILL_COLOR : bg);
        g2.fillPolygon(p);
        g2.setColor(fg);
        g2.drawPolygon(p);
        g2.setColor(Color.BLACK);
        if (ps > 0 && label.length() > 0) {
            g2.setFont(new Font("SansSerif", 0, ps));
            FontMetrics fm = g2.getFontMetrics();
            int x0 = x - fm.stringWidth(label) / 2;
            int y0 = (int)Math.round((double)y + 0.35 * (double)fm.getAscent());
            g2.drawString(label, x0, y0);
        }
        g2.dispose();
    }

    public static void drawSimpleKarel(Graphics g, int x, int y, int size, int dir, Color bg) {
        Graphics2D g2 = (Graphics2D)g.create();
        Color fg = g2.getColor();
        g2.translate(x, y);
        g2.rotate(-Direction.getRotationAngle(dir));
        Polygon p = new Polygon();
        p.addPoint(-size / 2, -size / 2);
        p.addPoint(-size / 2, size / 2);
        p.addPoint(0, size / 2);
        p.addPoint(size / 2, 0);
        p.addPoint(0, -size / 2);
        p.addPoint(-size / 2, -size / 2);
        g2.setColor(bg == null ? Color.WHITE : bg);
        g2.fillPolygon(p);
        g2.setColor(fg);
        g2.drawPolygon(p);
        g2.dispose();
    }

    public static void drawFancyKarel(Graphics g, int x, int y, int size, int dir, Color bg) {
        Graphics2D g2 = (Graphics2D)g.create();
        Color fg = g2.getColor();
        g2.translate(x, y);
        g2.rotate(-Direction.getRotationAngle(dir));
        int pass = 0;
        while (pass < 2) {
            Polygon p = new Polygon();
            double cx = (double)size * -0.2;
            double cy = (double)(-size) * -0.23;
            double sx = cx + (double)size * 0.13;
            double sy = cy - (double)size * 0.18000000000000002;
            KarelGraphics.addVertex(p, cx, cy);
            KarelGraphics.addVertex(p, cx, cy -= (double)size * 0.7000000000000001);
            KarelGraphics.addVertex(p, cx += (double)size * 0.44999999999999996, cy);
            KarelGraphics.addVertex(p, cx += (double)size * 0.15, cy += (double)size * 0.15);
            KarelGraphics.addVertex(p, cx, cy += (double)size * 0.65);
            KarelGraphics.addVertex(p, cx -= (double)size * 0.5, cy);
            KarelGraphics.addVertex(p, cx -= (double)size * 0.1, cy -= (double)size * 0.1);
            if (pass == 1) {
                g2.setColor(fg);
                g2.drawPolygon(p);
                p = new Polygon();
            }
            KarelGraphics.addVertex(p, sx, sy);
            KarelGraphics.addVertex(p, sx += 0.3 * (double)size, sy);
            KarelGraphics.addVertex(p, sx, sy -= 0.4 * (double)size);
            KarelGraphics.addVertex(p, sx -= 0.3 * (double)size, sy);
            KarelGraphics.addVertex(p, sx, sy += 0.4 * (double)size);
            if (pass == 0) {
                g2.setColor(bg == null ? Color.WHITE : bg);
                g2.fillPolygon(p);
            } else {
                g2.setColor(fg);
                g2.drawPolygon(p);
            }
            ++pass;
        }
        g2.setColor(fg);
        Polygon p = new Polygon();
        double cx = (double)size * 0.22999999999999998;
        double cy = (double)(-size) * -0.38 / 2.0;
        KarelGraphics.addVertex(p, cx - (double)size * 0.15, cy);
        KarelGraphics.addVertex(p, cx, cy);
        g2.drawPolygon(p);
        p = new Polygon();
        cx = (double)size * -0.2;
        cy = (double)(-size) * -0.05;
        KarelGraphics.addVertex(p, cx, cy);
        KarelGraphics.addVertex(p, cx -= (double)size * 0.16, cy);
        KarelGraphics.addVertex(p, cx, cy += (double)size * 0.2);
        KarelGraphics.addVertex(p, cx += (double)size * 0.08, cy);
        KarelGraphics.addVertex(p, cx, cy -= (double)size * 0.12000000000000001);
        KarelGraphics.addVertex(p, cx += (double)size * 0.08, cy);
        KarelGraphics.addVertex(p, cx, cy -= (double)size * 0.08);
        g2.fillPolygon(p);
        g2.drawPolygon(p);
        p = new Polygon();
        cx = (double)size * 0.07999999999999999;
        cy = (double)(-size) * -0.33;
        KarelGraphics.addVertex(p, cx, cy);
        KarelGraphics.addVertex(p, cx, cy += (double)size * 0.16);
        KarelGraphics.addVertex(p, cx += (double)size * 0.2, cy);
        KarelGraphics.addVertex(p, cx, cy -= (double)size * 0.08);
        KarelGraphics.addVertex(p, cx -= (double)size * 0.12000000000000001, cy);
        KarelGraphics.addVertex(p, cx, cy -= (double)size * 0.08);
        KarelGraphics.addVertex(p, cx -= (double)size * 0.08, cy);
        g2.fillPolygon(p);
        g2.drawPolygon(p);
        g2.dispose();
    }

    public static void drawVerticalWall(Graphics g, int x, int y, int size) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setStroke(NORMAL_WALL);
        g2.drawLine(x, y, x, y + size);
        g2.dispose();
    }

    public static void drawHorizontalWall(Graphics g, int x, int y, int size) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setStroke(NORMAL_WALL);
        g2.drawLine(x, y, x + size, y);
        g2.dispose();
    }

    private static void addVertex(Polygon p, double x, double y) {
        p.addPoint((int)Math.round(x), (int)Math.round(y));
    }
}

