/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.jskarel;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;

public class KarelLayout
implements LayoutManager {
    private Component controls = null;
    private Component editor = null;
    private Component ui = null;
    private Component world = null;

    @Override
    public void addLayoutComponent(String name, Component comp) {
        if (name.equals("controls")) {
            this.controls = comp;
        } else if (name.equals("world")) {
            this.world = comp;
        } else if (name.equals("ui")) {
            this.ui = comp;
        } else if (name.equals("editor")) {
            this.editor = comp;
        } else {
            throw new RuntimeException("Illegal component name: " + name);
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int ch = this.controls == null ? 0 : this.controls.getPreferredSize().height;
            int width = 830 + insets.left + insets.right;
            int height = 530 + ch + insets.top + insets.bottom;
            return new Dimension(width, height);
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            int h;
            int w;
            int y;
            int x;
            Insets insets = target.getInsets();
            Rectangle bounds = target.getBounds();
            int ch = this.controls == null ? 0 : this.controls.getPreferredSize().height;
            int x0 = insets.left;
            int y0 = insets.top;
            int width = bounds.width - insets.left - insets.right;
            int height = bounds.height - insets.top - insets.bottom;
            if (this.world != null) {
                x = x0 + 10;
                y = y0 + 10;
                w = 400;
                h = 400;
                this.world.setBounds(x, y, w, h);
            }
            if (this.ui != null) {
                x = x0 + 10;
                y = y0 + 10 + 400 + 10;
                w = 400;
                h = y0 + height - y - 10 - ch;
                this.ui.setBounds(x, y, w, h);
            }
            if (this.editor != null) {
                x = x0 + 10 + 400 + 10;
                y = y0 + 10;
                w = x0 + width - x - 10;
                h = y0 + height - y - 10 - ch;
                this.editor.setBounds(x, y, w, h);
            }
            if (this.controls != null) {
                this.controls.setBounds(0, height - ch, width, ch);
            }
        }
    }
}

