/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.jskarel;

import edu.stanford.cs.java2js.JSFile;
import edu.stanford.cs.java2js.JSFrame;
import edu.stanford.cs.jskarel.JSKarel;
import edu.stanford.cs.jskarel.KarelEditor;
import edu.stanford.cs.jskarel.KarelLoadWorldListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class KarelLoadFileListener
implements ActionListener {
    private JSKarel app;
    private String path;

    public KarelLoadFileListener(JSKarel app, String path) {
        this.app = app;
        this.path = path;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.path.endsWith(".w")) {
            this.app.getWorld().load(e.getActionCommand());
            this.app.setVMSpeed(this.app.getWorld().getSpeed());
        } else {
            KarelEditor editor = this.app.getEditor();
            editor.setFile(new JSFile(this.path));
            String file = String.valueOf(JSFile.getRoot(this.path)) + ".w";
            new JSFile(file).read(new KarelLoadWorldListener(this.app, file));
            editor.removeAllBreakpoints();
            editor.setText(e.getActionCommand());
            editor.setCursorPosition(0);
            JSFrame frame = editor.getFrame();
            if (frame != null) {
                frame.setTitle(JSFile.getTail(this.path));
            }
            this.app.parseProgram();
            editor.setSaveNeeded(false);
            this.app.updateControls();
        }
    }
}

