/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.jskarel;

import edu.stanford.cs.exp.Compound;
import edu.stanford.cs.exp.Constant;
import edu.stanford.cs.exp.Expression;
import edu.stanford.cs.exp.Value;
import edu.stanford.cs.jskarel.KarelANDOperator;
import edu.stanford.cs.jskarel.KarelBlockOperator;
import edu.stanford.cs.jskarel.KarelCornerColorIsOperator;
import edu.stanford.cs.jskarel.KarelFunctionKeyword;
import edu.stanford.cs.jskarel.KarelIfStatement;
import edu.stanford.cs.jskarel.KarelNOTOperator;
import edu.stanford.cs.jskarel.KarelOROperator;
import edu.stanford.cs.jskarel.KarelPaintCornerStatement;
import edu.stanford.cs.jskarel.KarelParenOperator;
import edu.stanford.cs.jskarel.KarelPauseStatement;
import edu.stanford.cs.jskarel.KarelRandomOperator;
import edu.stanford.cs.jskarel.KarelRepeatStatement;
import edu.stanford.cs.jskarel.KarelStatementOperator;
import edu.stanford.cs.jskarel.KarelWhileStatement;
import edu.stanford.cs.jskarel.StatementContext;
import edu.stanford.cs.parser.CodeVector;
import edu.stanford.cs.parser.Operator;
import edu.stanford.cs.parser.Parser;
import edu.stanford.cs.parser.Statement;
import edu.stanford.cs.parser.SyntaxError;
import edu.stanford.cs.svm.SVMModule;
import edu.stanford.cs.tokenscanner.TokenScanner;
import java.util.ArrayList;
import java.util.Stack;

public class KarelParser
extends Parser {
    private Operator blockOperator = new KarelBlockOperator();
    private Operator functionKeyword;
    private Operator statementOperator = new KarelStatementOperator();
    private Stack<StatementContext> statementStack;

    public KarelParser() {
        this.functionKeyword = new KarelFunctionKeyword();
        this.statementStack = new Stack();
        this.defineOperators();
        this.defineStatementForms();
    }

    @Override
    public TokenScanner createTokenScanner() {
        TokenScanner scanner = new TokenScanner();
        scanner.ignoreWhitespace();
        scanner.ignoreComments();
        scanner.scanStrings();
        scanner.scanNumbers();
        scanner.addWordCharacters("_");
        this.addOperatorTokens(scanner);
        return scanner;
    }

    public void addOperatorTokens(TokenScanner scanner) {
        scanner.addOperator("&&");
        scanner.addOperator("||");
    }

    public void defineOperators() {
        int LEFT = 0;
        int RIGHT = 1;
        this.defineOperator("(", new KarelParenOperator(), 0, 110, RIGHT);
        this.definePrefixOperator("!", new KarelNOTOperator(), 100);
        this.defineInfixOperator("&&", new KarelANDOperator(), 30, LEFT);
        this.defineInfixOperator("||", new KarelOROperator(), 20, LEFT);
        this.definePrefixOperator("cornerColorIs", new KarelCornerColorIsOperator(), 110);
        this.definePrefixOperator("random", new KarelRandomOperator(), 110);
    }

    public SVMModule readModule(String pathname) {
        SVMModule module = new SVMModule(pathname);
        while (this.hasMoreTokens()) {
            String token = this.nextToken();
            this.saveToken(token);
            if (token.equals("import")) {
                module.addImport(this.readImport());
                continue;
            }
            if (token.equals("function")) {
                module.addFunction(this.readFunction());
                continue;
            }
            throw new SyntaxError("Unexpected token: " + token);
        }
        return module;
    }

    public String readImport() {
        this.verifyToken("import");
        String token = this.nextToken();
        if (this.getTokenType(token) != 3) {
            throw new SyntaxError("Missing library name in import");
        }
        this.verifyToken(";");
        return this.getStringValue(token);
    }

    public Expression readFunction() {
        String token = this.nextToken();
        if (token.equals("function")) {
            return this.readFunctionEntry();
        }
        throw new SyntaxError("Illegal top-level definition");
    }

    public CodeVector compileFunction(Expression fn) {
        Expression body = fn.getArgs()[3];
        CodeVector cv = new CodeVector();
        this.compile(body, cv);
        cv.addInstruction(99, 0);
        return cv;
    }

    public Expression readFunctionEntry() {
        String name = this.nextToken();
        this.verifyToken("(");
        this.verifyToken(")");
        ArrayList<String> formals = new ArrayList<String>();
        ArrayList<String> locals = new ArrayList<String>();
        Expression body = this.readCompoundStatement();
        Expression fn = this.createCompound4(this.functionKeyword, this.createIdentifier(name), this.createList("formals", formals), this.createList("locals", locals), body);
        return fn;
    }

    public void defineStatementForms() {
        this.defineStatementForm("if", new KarelIfStatement());
        this.defineStatementForm("while", new KarelWhileStatement());
        this.defineStatementForm("repeat", new KarelRepeatStatement());
        this.defineStatementForm("pause", new KarelPauseStatement());
        this.defineStatementForm("paintCorner", new KarelPaintCornerStatement());
    }

    @Override
    public void compile(Expression exp, CodeVector cv) {
        int type = exp.getType();
        switch (type) {
            case 1: {
                this.compileConstant(exp.getValue(), cv);
                break;
            }
            case 2: {
                this.compileIdentifier(exp.getName(), cv);
                break;
            }
            case 3: {
                this.compileCompound((Compound)exp, cv);
            }
        }
    }

    public void compileConstant(Value value, CodeVector cv) {
        int type = value.getType();
        switch (type) {
            case 66: {
                String fn = "Boolean." + value.getValue();
                cv.addInstruction(97, cv.stringRef(fn));
                break;
            }
            case 67: {
                int ch = (Integer)value.getValue();
                cv.addInstruction(16, ch);
                break;
            }
            case 68: {
                cv.addInstruction(17, cv.stringRef("" + value.getValue()));
                break;
            }
            case 73: {
                int n = (Integer)value.getValue();
                if ((n & 0xFFFFFF) == n) {
                    cv.addInstruction(16, n);
                    break;
                }
                cv.addInstruction(17, cv.stringRef("" + n));
                break;
            }
            case 83: {
                String str = (String)value.getValue();
                cv.addInstruction(18, cv.stringRef(str));
                break;
            }
            default: {
                throw new SyntaxError("Illegal value: " + value);
            }
        }
    }

    public void compileIdentifier(String name, CodeVector cv) {
        cv.addInstruction(108, cv.stringRef(name));
    }

    public void compileCompound(Compound exp, CodeVector cv) {
        Expression fn = exp.getFunction();
        int type = fn.getType();
        if (type == 4) {
            ((Operator)fn).compile(this, exp.getArgs(), cv);
        } else {
            this.compileCall(fn.toString(), cv);
        }
    }

    public void compileArgs(Expression[] args, CodeVector cv) {
        int n = args.length;
        int i = 0;
        while (i < n) {
            this.compile(args[i], cv);
            ++i;
        }
    }

    public void compileCall(String name, CodeVector cv) {
        String tag = cv.newLabel();
        cv.addInstruction(18, cv.stringRef(name));
        cv.addInstruction(97, cv.stringRef("Global.isDefined"));
        cv.addInstruction(65, cv.labelRef(tag));
        cv.addInstruction(18, cv.stringRef("Function " + name + " is undefined"));
        cv.addInstruction(70, 0);
        cv.defineLabel(tag);
        cv.addInstruction(18, cv.stringRef(name));
        cv.addInstruction(97, cv.stringRef("Global.get"));
        cv.addInstruction(98, 0);
    }

    private Expression createList(String key, ArrayList<String> list) {
        int n = list.size();
        Expression[] args = new Expression[n];
        int i = 0;
        while (i < n) {
            args[i] = this.createIdentifier(list.get(i));
            ++i;
        }
        return this.createCompound(this.createIdentifier(key), args);
    }

    public Expression readStatement() {
        String token = this.nextToken();
        if (token == null) {
            throw new SyntaxError("Unexpected end of line");
        }
        this.saveToken(token);
        if (token.equals("{")) {
            return this.readCompoundStatement();
        }
        Constant pos = new Constant(Value.createInteger(this.getPosition()));
        Operator op = this.getOperator(token);
        if (op == null || !op.isStatement()) {
            token = this.nextToken();
            Expression exp = this.createCompound0(this.createIdentifier(token));
            this.verifyToken("(");
            this.verifyToken(")");
            this.verifyToken(";");
            return this.createCompound2(this.statementOperator, pos, exp);
        }
        this.nextToken();
        return this.createCompound2(this.statementOperator, pos, op.prefixAction(this));
    }

    public Expression readCompoundStatement() {
        this.verifyToken("{");
        ArrayList<Expression> statements = new ArrayList<Expression>();
        String token = this.nextToken();
        if (!token.equals("}")) {
            this.saveToken(token);
            while (true) {
                statements.add(this.readStatement());
                token = this.nextToken();
                if (token.equals("}")) break;
                this.saveToken(token);
            }
        }
        int n = statements.size();
        Expression[] array = new Expression[n];
        int i = 0;
        while (i < n) {
            array[i] = (Expression)statements.get(i);
            ++i;
        }
        return this.createCompound(this.blockOperator, array);
    }

    @Override
    public Expression readT() {
        String token = this.nextToken();
        if (token == null) {
            throw new SyntaxError("Unexpected end of line");
        }
        switch (this.getTokenType(token)) {
            case 1: 
            case 4: {
                Operator op = this.getOperator(token);
                if (op == null) {
                    this.verifyToken("(");
                    this.verifyToken(")");
                    return this.createCompound0(this.createIdentifier(token));
                }
                if (op.isStatement()) {
                    throw new SyntaxError("Illegal context for " + this.markCode("" + op));
                }
                return op.prefixAction(this);
            }
        }
        throw new SyntaxError("Illegal condition " + this.markCode(token));
    }

    public void defineStatementForm(String name, Statement op) {
        this.defineOperator(name, op, 0, 0, 0);
    }

    public void pushStatementContext(String breakLabel, String continueLabel) {
        StatementContext sc = new StatementContext();
        sc.breakLabel = breakLabel;
        sc.continueLabel = continueLabel;
        sc.nextLabel = null;
        this.statementStack.push(sc);
    }

    public void popStatementContext() {
        this.statementStack.pop();
    }

    public int getStatementDepth() {
        return this.statementStack.size();
    }

    public void setNextLabel(String str) {
        this.statementStack.peek().nextLabel = str;
    }

    public String getNextLabel() {
        return this.statementStack.peek().nextLabel;
    }

    public String getBreakLabel() {
        return this.statementStack.peek().breakLabel;
    }

    public String getContinueLabel() {
        return this.statementStack.peek().continueLabel;
    }

    @Override
    public Expression parseConstant(String token) {
        int type = this.getTokenType(token);
        if (type == 2) {
            if (token.indexOf(".") >= 0) {
                return new Constant(Value.createDouble(Double.parseDouble(token)));
            }
            if (token.startsWith("0x") || token.startsWith("0X")) {
                int n = Integer.parseInt(token.substring(2), 16);
                return new Constant(Value.createInteger(n));
            }
            if (token.startsWith("0")) {
                int n = Integer.parseInt(token, 8);
                return new Constant(Value.createInteger(n));
            }
            return new Constant(Value.createInteger(Integer.parseInt(token)));
        }
        if (type == 3) {
            String s = this.getStringValue(token);
            return new Constant(Value.createString(s));
        }
        throw new SyntaxError("Illegal constant: " + this.markCode(token));
    }
}

