/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.jskarel;

import edu.stanford.cs.exp.Expression;
import edu.stanford.cs.jskarel.KarelParser;
import edu.stanford.cs.parser.CodeVector;
import edu.stanford.cs.parser.Parser;
import edu.stanford.cs.parser.Statement;
import edu.stanford.cs.parser.SyntaxError;

public class KarelRepeatStatement
extends Statement {
    @Override
    public Expression prefixAction(Parser p) {
        p.verifyToken("(");
        String token = p.nextToken();
        int type = p.getTokenType(token);
        if (type != 2) {
            throw new SyntaxError("Missing repeat count");
        }
        Expression count = p.parseConstant(token);
        p.verifyToken(")");
        Expression stmt = ((KarelParser)p).readCompoundStatement();
        return p.createCompound2(this, count, stmt);
    }

    @Override
    public void compile(Parser p, Expression[] args, CodeVector cv) {
        KarelParser jsp = (KarelParser)p;
        Expression count = args[0];
        Expression stmt = args[1];
        String tag1 = cv.newLabel();
        String tag2 = cv.newLabel();
        String tag3 = cv.newLabel();
        jsp.pushStatementContext(tag3, tag2);
        String index = "i_" + jsp.getStatementDepth();
        String max = "n_" + jsp.getStatementDepth();
        cv.addInstruction(104, cv.stringRef(index));
        cv.addInstruction(104, cv.stringRef(max));
        p.compile(count, cv);
        cv.addInstruction(109, cv.stringRef(max));
        cv.addInstruction(16, 0);
        cv.addInstruction(109, cv.stringRef(index));
        cv.defineLabel(tag1);
        cv.addInstruction(108, cv.stringRef(index));
        cv.addInstruction(108, cv.stringRef(max));
        cv.addInstruction(50, 0);
        cv.addInstruction(66, cv.labelRef(tag3));
        jsp.compile(stmt, cv);
        cv.defineLabel(tag2);
        cv.addInstruction(108, cv.stringRef(index));
        cv.addInstruction(16, 1);
        cv.addInstruction(32, 0);
        cv.addInstruction(109, cv.stringRef(index));
        cv.addInstruction(64, cv.labelRef(tag1));
        cv.defineLabel(tag3);
        jsp.popStatementContext();
    }
}

