/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.jskarel;

import edu.stanford.cs.exp.Value;
import edu.stanford.cs.jskarel.JSKarel;
import edu.stanford.cs.jskarel.KarelBeepersInBag;
import edu.stanford.cs.jskarel.KarelBeepersPresent;
import edu.stanford.cs.jskarel.KarelConsole;
import edu.stanford.cs.jskarel.KarelCornerColorIs;
import edu.stanford.cs.jskarel.KarelEditor;
import edu.stanford.cs.jskarel.KarelFacingEast;
import edu.stanford.cs.jskarel.KarelFacingNorth;
import edu.stanford.cs.jskarel.KarelFacingSouth;
import edu.stanford.cs.jskarel.KarelFacingWest;
import edu.stanford.cs.jskarel.KarelFrontIsBlocked;
import edu.stanford.cs.jskarel.KarelFrontIsClear;
import edu.stanford.cs.jskarel.KarelLeftIsBlocked;
import edu.stanford.cs.jskarel.KarelLeftIsClear;
import edu.stanford.cs.jskarel.KarelMove;
import edu.stanford.cs.jskarel.KarelNoBeepersPresent;
import edu.stanford.cs.jskarel.KarelNotFacingEast;
import edu.stanford.cs.jskarel.KarelNotFacingNorth;
import edu.stanford.cs.jskarel.KarelNotFacingSouth;
import edu.stanford.cs.jskarel.KarelNotFacingWest;
import edu.stanford.cs.jskarel.KarelPaintCorner;
import edu.stanford.cs.jskarel.KarelPause;
import edu.stanford.cs.jskarel.KarelPickBeeper;
import edu.stanford.cs.jskarel.KarelPutBeeper;
import edu.stanford.cs.jskarel.KarelRandom;
import edu.stanford.cs.jskarel.KarelRightIsBlocked;
import edu.stanford.cs.jskarel.KarelRightIsClear;
import edu.stanford.cs.jskarel.KarelTimerListener;
import edu.stanford.cs.jskarel.KarelTurnAround;
import edu.stanford.cs.jskarel.KarelTurnLeft;
import edu.stanford.cs.jskarel.KarelTurnRight;
import edu.stanford.cs.jskarel.KarelVMChangeListener;
import edu.stanford.cs.jskarel.KarelWorld;
import edu.stanford.cs.parser.CodeVector;
import edu.stanford.cs.svm.SVM;
import edu.stanford.cs.svm.SVMMethod;
import java.awt.event.ActionListener;

public class KarelVM
extends SVM {
    private JSKarel app;
    private boolean stepTaken;

    public KarelVM(JSKarel app) {
        this.app = app;
        this.defineBuiltInFunctions();
        this.setTarget(this);
        this.setStepMode(1);
        this.addChangeListener(new KarelVMChangeListener(app));
        this.stepTaken = false;
    }

    public KarelEditor getEditor() {
        return this.app.getEditor();
    }

    @Override
    public KarelConsole getConsole() {
        return this.app.getConsole();
    }

    public KarelWorld getWorld() {
        return this.app.getWorld();
    }

    public boolean execute(String str, int state) {
        Value v = this.getGlobal(str);
        if (v == null || v == Value.UNDEFINED) {
            this.getEditor().showErrorDialog(String.valueOf(str) + " is undefined", 0);
            return true;
        }
        String type = v.getClassName();
        if (type.equals("FunctionClosure")) {
            this.push(v);
            CodeVector cv = new CodeVector();
            cv.addInstruction(98, 0);
            this.setCode(cv.getCode());
            this.setPC(0);
            this.start(state);
            return false;
        }
        SVMMethod fn = (SVMMethod)v.getValue();
        fn.execute(this, null);
        return true;
    }

    public void defineTurns() {
        this.defineMethod("turnRight", new KarelTurnRight());
        this.defineMethod("turnAround", new KarelTurnAround());
    }

    public void defineExtensions() {
        this.defineMethod("paintCorner", new KarelPaintCorner());
        this.defineMethod("cornerColorIs", new KarelCornerColorIs());
        this.defineMethod("pause", new KarelPause());
        this.defineMethod("random", new KarelRandom());
    }

    public void setStepTaken(boolean flag) {
        this.stepTaken = flag;
    }

    public boolean isStepTaken() {
        return this.stepTaken;
    }

    @Override
    protected void stepHook() {
        this.app.statementHook(this.getStatementOffset());
    }

    @Override
    protected ActionListener createTimerListener() {
        return new KarelTimerListener(this);
    }

    private void defineBuiltInFunctions() {
        this.defineMethod("move", new KarelMove());
        this.defineMethod("turnLeft", new KarelTurnLeft());
        this.defineMethod("pickBeeper", new KarelPickBeeper());
        this.defineMethod("putBeeper", new KarelPutBeeper());
        this.defineMethod("frontIsClear", new KarelFrontIsClear());
        this.defineMethod("frontIsBlocked", new KarelFrontIsBlocked());
        this.defineMethod("leftIsClear", new KarelLeftIsClear());
        this.defineMethod("leftIsBlocked", new KarelLeftIsBlocked());
        this.defineMethod("rightIsClear", new KarelRightIsClear());
        this.defineMethod("rightIsBlocked", new KarelRightIsBlocked());
        this.defineMethod("beepersInBag", new KarelBeepersInBag());
        this.defineMethod("noBeepersInBag", new KarelBeepersInBag());
        this.defineMethod("beepersPresent", new KarelBeepersPresent());
        this.defineMethod("noBeepersPresent", new KarelNoBeepersPresent());
        this.defineMethod("facingNorth", new KarelFacingNorth());
        this.defineMethod("notFacingNorth", new KarelNotFacingNorth());
        this.defineMethod("facingSouth", new KarelFacingSouth());
        this.defineMethod("notFacingSouth", new KarelNotFacingSouth());
        this.defineMethod("facingEast", new KarelFacingEast());
        this.defineMethod("notFacingEast", new KarelNotFacingEast());
        this.defineMethod("facingWest", new KarelFacingWest());
        this.defineMethod("notFacingWest", new KarelNotFacingWest());
    }

    private void defineMethod(String name, SVMMethod method) {
        this.setGlobal(name, Value.createObject(method, "SVMMethod"));
    }
}

