/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.jskarel;

import edu.stanford.cs.jskarel.Corner;
import edu.stanford.cs.jskarel.Karel;
import edu.stanford.cs.tokenscanner.TokenScanner;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class KarelWorld {
    private static final int NORTH = 0;
    private static final int EAST = 1;
    private static final int SOUTH = 2;
    private static final int WEST = 3;
    private static final String EOL = "\n";
    private ArrayList<ChangeListener> listeners = new ArrayList();
    private Corner[][] map;
    private Karel karel = new Karel();
    private String filePath;
    private boolean loadInProgress;
    private double speed;
    private int width;
    private int height;

    public KarelWorld() {
        this.karel.setWorld(this);
        this.resize(10, 10);
    }

    public void resize(int width, int height) {
        this.width = width;
        this.height = height;
        this.map = new Corner[width + 2][height + 2];
        int x = 1;
        while (x <= width + 1) {
            int y = 1;
            while (y <= height + 1) {
                this.map[x][y] = new Corner();
                this.map[x][y].wallSouth = y == 1 || y == height + 1;
                this.map[x][y].wallWest = x == 1 || x == width + 1;
                this.map[x][y].color = null;
                this.map[x][y].nBeepers = 0;
                ++y;
            }
            ++x;
        }
        this.karel.setLocation(1, 1);
        this.karel.setDirection(1);
        this.update();
    }

    public Karel getKarel() {
        return this.karel;
    }

    public void setFilePath(String path) {
        this.filePath = path;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void reset() {
    }

    public int getNCols() {
        return this.width;
    }

    public int getNRows() {
        return this.height;
    }

    public boolean outOfBounds(int x, int y) {
        return x < 1 || x > this.width || y < 1 || y > this.height;
    }

    public int getBeepersOnCorner(int x, int y) {
        return this.map[x][y].nBeepers;
    }

    public void setBeepersOnCorner(int x, int y, int nBeepers) {
        this.map[x][y].nBeepers = nBeepers;
        this.update();
    }

    public static int adjustBeepers(int nBeepers, int delta) {
        if (nBeepers == 99999999) {
            return 99999999;
        }
        return Math.max(nBeepers + delta, 0);
    }

    public static int setBeepers(int nBeepers, int delta) {
        if (delta == 99999999) {
            return 99999999;
        }
        if (delta == -1) {
            return nBeepers == 99999999 ? 99999999 : nBeepers + 1;
        }
        if (delta == -2) {
            if (nBeepers == 0) {
                return 0;
            }
            return nBeepers == 99999999 ? 99999999 : nBeepers - 1;
        }
        return delta;
    }

    public Color getCornerColor(int x, int y) {
        return this.map[x][y].color;
    }

    public void setCornerColor(int x, int y, Color color) {
        this.map[x][y].color = color;
        this.update();
    }

    public boolean checkWall(int x, int y, int dir) {
        switch (dir) {
            case 2: {
                return this.map[x][y].wallSouth;
            }
            case 3: {
                return this.map[x][y].wallWest;
            }
            case 0: {
                return this.map[x][y + 1].wallSouth;
            }
            case 1: {
                return this.map[x + 1][y].wallWest;
            }
        }
        return false;
    }

    public void setWall(int x, int y, int dir) {
        switch (dir) {
            case 2: {
                this.map[x][y].wallSouth = true;
                break;
            }
            case 3: {
                this.map[x][y].wallWest = true;
                break;
            }
            case 0: {
                this.map[x][y + 1].wallSouth = true;
                break;
            }
            case 1: {
                this.map[x + 1][y].wallWest = true;
            }
        }
        this.update();
    }

    public void clearWall(int x, int y, int dir) {
        switch (dir) {
            case 2: {
                this.map[x][y].wallSouth = false;
                break;
            }
            case 3: {
                this.map[x][y].wallWest = false;
                break;
            }
            case 0: {
                this.map[x][y + 1].wallSouth = false;
                break;
            }
            case 1: {
                this.map[x + 1][y].wallWest = false;
            }
        }
        this.update();
    }

    public void trace() {
        this.update();
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void update() {
        if (!this.loadInProgress) {
            this.fireChangeListeners();
        }
    }

    public void fireChangeListeners() {
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(new ChangeEvent(this));
        }
    }

    private static String encodeColor(Color color) {
        if (color.equals(Color.BLACK)) {
            return "BLACK";
        }
        if (color.equals(Color.BLUE)) {
            return "BLUE";
        }
        if (color.equals(Color.CYAN)) {
            return "CYAN";
        }
        if (color.equals(Color.DARK_GRAY)) {
            return "DARK_GRAY";
        }
        if (color.equals(Color.GRAY)) {
            return "GRAY";
        }
        if (color.equals(Color.GREEN)) {
            return "GREEN";
        }
        if (color.equals(Color.LIGHT_GRAY)) {
            return "LIGHT_GRAY";
        }
        if (color.equals(Color.MAGENTA)) {
            return "MAGENTA";
        }
        if (color.equals(Color.ORANGE)) {
            return "ORANGE";
        }
        if (color.equals(Color.PINK)) {
            return "PINK";
        }
        if (color.equals(Color.RED)) {
            return "RED";
        }
        if (color.equals(Color.WHITE)) {
            return "WHITE";
        }
        if (color.equals(Color.YELLOW)) {
            return "YELLOW";
        }
        return "0x" + Integer.toString(color.getRGB() & 0xFFFFFF).toUpperCase();
    }

    private static Color decodeColor(String name) {
        if (name.equalsIgnoreCase("black")) {
            return Color.BLACK;
        }
        if (name.equalsIgnoreCase("blue")) {
            return Color.BLUE;
        }
        if (name.equalsIgnoreCase("cyan")) {
            return Color.CYAN;
        }
        if (name.equalsIgnoreCase("darkgray")) {
            return Color.DARK_GRAY;
        }
        if (name.equalsIgnoreCase("dark_gray")) {
            return Color.DARK_GRAY;
        }
        if (name.equalsIgnoreCase("gray")) {
            return Color.GRAY;
        }
        if (name.equalsIgnoreCase("green")) {
            return Color.GREEN;
        }
        if (name.equalsIgnoreCase("lightgray")) {
            return Color.LIGHT_GRAY;
        }
        if (name.equalsIgnoreCase("light_gray")) {
            return Color.LIGHT_GRAY;
        }
        if (name.equalsIgnoreCase("magenta")) {
            return Color.MAGENTA;
        }
        if (name.equalsIgnoreCase("orange")) {
            return Color.ORANGE;
        }
        if (name.equalsIgnoreCase("pink")) {
            return Color.PINK;
        }
        if (name.equalsIgnoreCase("red")) {
            return Color.RED;
        }
        if (name.equalsIgnoreCase("white")) {
            return Color.WHITE;
        }
        if (name.equalsIgnoreCase("yellow")) {
            return Color.YELLOW;
        }
        return Color.decode(name);
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public double getSpeed() {
        return this.speed;
    }

    public String getText() {
        int y;
        String result = "";
        result = String.valueOf(result) + "Dimension: (" + this.width + ", " + this.height + ")\n";
        int x = 1;
        while (x <= this.width) {
            y = 1;
            while (y <= this.height) {
                if (x > 1 && this.checkWall(x, y, 3)) {
                    result = String.valueOf(result) + "Wall: (" + x + ", " + y + ") WEST\n";
                }
                if (y > 1 && this.checkWall(x, y, 2)) {
                    result = String.valueOf(result) + "Wall: (" + x + ", " + y + ") SOUTH\n";
                }
                ++y;
            }
            ++x;
        }
        x = 1;
        while (x <= this.width) {
            y = 1;
            while (y <= this.height) {
                int nBeepers;
                Color color = this.getCornerColor(x, y);
                if (color != null) {
                    result = String.valueOf(result) + "Color: (" + x + ", " + y + ") " + KarelWorld.encodeColor(color) + EOL;
                }
                if ((nBeepers = this.getBeepersOnCorner(x, y)) != 0) {
                    String str = nBeepers == 99999999 ? "INFINITE" : "" + nBeepers;
                    result = String.valueOf(result) + "Beeper: (" + x + ", " + y + ") " + str + EOL;
                }
                ++y;
            }
            ++x;
        }
        String dirName = "Error";
        switch (this.karel.getDirection()) {
            case 0: {
                dirName = "NORTH";
                break;
            }
            case 1: {
                dirName = "EAST";
                break;
            }
            case 2: {
                dirName = "SOUTH";
                break;
            }
            case 3: {
                dirName = "WEST";
            }
        }
        Point loc = this.karel.getLocation();
        result = String.valueOf(result) + "Karel: (" + loc.x + ", " + loc.y + ") " + dirName + EOL;
        int nBeepers = this.karel.getBeepersInBag();
        String str = nBeepers == 99999999 ? "INFINITE" : "" + nBeepers;
        result = String.valueOf(result) + "BeeperBag: " + str + EOL;
        result = String.valueOf(result) + "Speed: " + this.speedFormat(this.getSpeed()) + EOL;
        return result;
    }

    private String speedFormat(double speed) {
        return (String.valueOf(speed) + "00").substring(0, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String str) {
        KarelWorld karelWorld = this;
        synchronized (karelWorld) {
            this.loadInProgress = true;
            TokenScanner scanner = new TokenScanner();
            scanner.ignoreWhitespace();
            scanner.ignoreComments();
            scanner.scanNumbers();
            scanner.scanStrings();
            scanner.addOperator(EOL);
            scanner.setInput(str);
            while (this.readMapLine(scanner)) {
            }
            this.loadInProgress = false;
        }
        this.update();
    }

    private boolean readMapLine(TokenScanner scanner) {
        String cmd = scanner.nextToken().toLowerCase();
        if (cmd.equals("")) {
            return false;
        }
        if (cmd.equals(EOL)) {
            return true;
        }
        scanner.verifyToken(":");
        if (cmd.equals("dimension")) {
            this.dimensionCommand(scanner);
        } else if (cmd.equals("karel")) {
            this.karelCommand(scanner);
        } else if (cmd.equals("wall")) {
            this.wallCommand(scanner);
        } else if (cmd.equals("color")) {
            this.setColorCommand(scanner);
        } else if (cmd.equals("speed")) {
            this.speedCommand(scanner);
        } else if (cmd.equals("beeper")) {
            this.beeperCommand(scanner);
        } else if (cmd.equals("beeperbag")) {
            this.beeperBagCommand(scanner);
        } else {
            throw new RuntimeException("Illegal command: " + cmd);
        }
        return true;
    }

    private void dimensionCommand(TokenScanner scanner) {
        Point pt = this.scanPoint(scanner);
        scanner.verifyToken(EOL);
        this.resize(pt.x, pt.y);
    }

    private void karelCommand(TokenScanner scanner) {
        Point pt = this.scanPoint(scanner);
        int dir = this.scanDirection(scanner);
        scanner.verifyToken(EOL);
        this.karel.setLocation(pt.x, pt.y);
        this.karel.setDirection(dir);
    }

    private void wallCommand(TokenScanner scanner) {
        Point pt = this.scanPoint(scanner);
        int dir = this.scanDirection(scanner);
        scanner.verifyToken(EOL);
        this.setWall(pt.x, pt.y, dir);
    }

    private void setColorCommand(TokenScanner scanner) {
        Point pt = this.scanPoint(scanner);
        String colorName = scanner.nextToken().toLowerCase();
        scanner.verifyToken(EOL);
        this.setCornerColor(pt.x, pt.y, KarelWorld.decodeColor(colorName));
    }

    private void speedCommand(TokenScanner scanner) {
        double speed = this.scanDouble(scanner);
        scanner.verifyToken(EOL);
        this.setSpeed(speed);
    }

    private void beeperCommand(TokenScanner scanner) {
        Point pt = this.scanPoint(scanner);
        int nBeepers = this.scanBeeperCount(scanner);
        scanner.verifyToken(EOL);
        this.setBeepersOnCorner(pt.x, pt.y, nBeepers);
    }

    private void beeperBagCommand(TokenScanner scanner) {
        int nBeepers = this.scanBeeperCount(scanner);
        scanner.verifyToken(EOL);
        this.karel.setBeepersInBag(nBeepers);
    }

    private int scanInt(TokenScanner scanner) {
        String token = scanner.nextToken();
        if (token.equals(EOL)) {
            throw new RuntimeException("Missing integer value");
        }
        try {
            return Integer.parseInt(token);
        }
        catch (NumberFormatException ex) {
            throw new RuntimeException("Illegal integer");
        }
    }

    private double scanDouble(TokenScanner scanner) {
        String token = scanner.nextToken();
        if (token.equals(EOL)) {
            throw new RuntimeException("Missing floating-point value");
        }
        try {
            return Double.parseDouble(token);
        }
        catch (NumberFormatException ex) {
            throw new RuntimeException("Illegal floating-point value");
        }
    }

    private int scanBeeperCount(TokenScanner scanner) {
        String token = scanner.nextToken().toLowerCase();
        if (token.equals(EOL)) {
            throw new RuntimeException("Missing beeper count");
        }
        if ("infinite".startsWith(token) || "infinity".startsWith(token)) {
            return 99999999;
        }
        scanner.saveToken(token);
        return this.scanInt(scanner);
    }

    private Point scanPoint(TokenScanner scanner) {
        Point pt = new Point(0, 0);
        scanner.verifyToken("(");
        pt.x = this.scanInt(scanner);
        scanner.verifyToken(",");
        pt.y = this.scanInt(scanner);
        scanner.verifyToken(")");
        return pt;
    }

    private int scanDirection(TokenScanner scanner) {
        String token = scanner.nextToken().toLowerCase();
        if (token.equals(EOL)) {
            throw new RuntimeException("Missing direction specification");
        }
        if ("north".startsWith(token)) {
            return 0;
        }
        if ("east".startsWith(token)) {
            return 1;
        }
        if ("south".startsWith(token)) {
            return 2;
        }
        if ("west".startsWith(token)) {
            return 3;
        }
        throw new RuntimeException("Illegal direction " + token);
    }
}

