/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.jskarel;

import edu.stanford.cs.java2js.JSCanvas;
import edu.stanford.cs.jskarel.BeeperBagTool;
import edu.stanford.cs.jskarel.BeeperTool;
import edu.stanford.cs.jskarel.ColorTool;
import edu.stanford.cs.jskarel.JSKarel;
import edu.stanford.cs.jskarel.KC;
import edu.stanford.cs.jskarel.Karel;
import edu.stanford.cs.jskarel.KarelTool;
import edu.stanford.cs.jskarel.KarelWorld;
import edu.stanford.cs.jskarel.KarelWorldMonitor;
import edu.stanford.cs.jskarel.KarelWorldView;
import edu.stanford.cs.jskarel.MapTool;
import edu.stanford.cs.jskarel.ResizeTool;
import edu.stanford.cs.jskarel.SaveTool;
import edu.stanford.cs.jskarel.WallTool;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;

class KarelWorldEditor
extends JSCanvas
implements KarelWorldMonitor,
KeyListener,
MouseListener {
    private ArrayList<MapTool> tools;
    private JSKarel app;
    private Karel activeKarel;
    private KarelWorld world;
    private KarelWorldView view;
    private MapTool selectedTool;
    private ResizeTool resizeTool;

    public KarelWorldEditor(JSKarel app, KarelWorldView view) {
        this.app = app;
        this.view = view;
        this.world = view.getWorld();
        this.activeKarel = null;
        this.selectedTool = null;
        this.setBackground(KC.APPLICATION_BACKGROUND);
        this.initEditorCanvas();
        this.addMouseListener(this);
        this.addKeyListener(this);
    }

    public JSKarel getApplication() {
        return this.app;
    }

    public void initEditorCanvas() {
        this.tools = new ArrayList();
        int x = 8;
        int y = 3;
        this.defineTool(new WallTool(x, y, true));
        this.defineTool(new WallTool(x, y + 20 + 6, false));
        this.defineTool(new BeeperTool(x += 32, y, 1));
        this.defineTool(new BeeperTool(x += 26, y, -1));
        this.defineTool(new BeeperTool(x += 26, y, -2));
        this.defineTool(new BeeperTool(x += 26, y, 0));
        this.defineTool(new BeeperTool(x += 26, y, 99999999));
        this.defineTool(new KarelTool(x += 32, y, 1));
        this.defineTool(new KarelTool(x += 26, y, 2));
        this.defineTool(new KarelTool(x += 26, y, 3));
        this.defineTool(new KarelTool(x += 26, y, 0));
        this.defineTool(new BeeperBagTool(x += 26, y));
        this.resizeTool = new ResizeTool(x += 41, y);
        this.defineTool(this.resizeTool);
        this.defineTool(new SaveTool(x += 52, y, true));
        this.defineTool(new SaveTool(x, y + 20 + 6, false));
        boolean useColors = true;
        if (useColors) {
            int nc = KC.COLORS.length;
            double top = 234.0;
            double dx = (top - (double)(nc * 12)) / (double)(nc - 1);
            x = 34;
            y += 28;
            int i = 0;
            while (i < KC.COLORS.length) {
                int cx = x + (int)Math.round((double)i * (12.0 + dx));
                this.defineTool(new ColorTool(cx, y, KC.COLORS[i]));
                ++i;
            }
        }
        this.selectedTool = this.tools.get(0);
    }

    public void dismissEditor(boolean saveFlag) {
        this.app.setEditWorldEnabled(false);
        if (saveFlag) {
            this.app.saveWorld();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int width = 200;
        int height = 137;
        return new Dimension(width, height);
    }

    public void setSelectedTool(MapTool tool) {
        this.selectedTool = tool;
        this.repaint();
    }

    public MapTool getSelectedTool() {
        return this.selectedTool;
    }

    public KarelWorld getWorld() {
        return this.world;
    }

    @Override
    public void paintComponent(Graphics g) {
        for (MapTool tool : this.tools) {
            tool.paint(g, this);
        }
    }

    @Override
    public KarelWorldView getView() {
        return this.view;
    }

    @Override
    public void setActiveKarel(Karel karel) {
        this.activeKarel = karel;
    }

    @Override
    public Karel getActiveKarel() {
        return this.activeKarel;
    }

    @Override
    public void wallAction(int x, int y, int dir) {
        MapTool tool;
        if (this.activeKarel == null && (tool = this.getSelectedTool()) != null) {
            tool.wallAction(this, x, y, dir);
        }
    }

    @Override
    public void cornerAction(int x, int y) {
        if (this.activeKarel == null) {
            MapTool tool = this.getSelectedTool();
            if (tool != null) {
                tool.cornerAction(this, x, y);
            }
        } else {
            this.activeKarel.setLocation(x, y);
            this.view.repaint();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.selectedTool == this.resizeTool) {
            int code = e.getKeyCode();
            if (code == 13 || code == 10) {
                this.resizeTool.processKey(this, 10);
            } else if (code == 8 || code == 127) {
                this.resizeTool.processKey(this, 8);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (this.selectedTool == this.resizeTool) {
            int code = e.getKeyCode();
            if (code == 13 || code == 10 || code == 8 || code == 127) {
                return;
            }
            this.resizeTool.processKey(this, e.getKeyChar());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        MapTool tool = this.findTool(e.getX(), e.getY());
        if (tool != null) {
            tool.toolAction(this);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void defineTool(MapTool tool) {
        this.tools.add(tool);
    }

    private MapTool findTool(int x, int y) {
        for (MapTool tool : this.tools) {
            if (!tool.contains(x, y)) continue;
            return tool;
        }
        return null;
    }
}

