/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.jskarel;

import edu.stanford.cs.java2js.JSCanvas;
import edu.stanford.cs.jskarel.KC;
import edu.stanford.cs.jskarel.Karel;
import edu.stanford.cs.jskarel.KarelGraphics;
import edu.stanford.cs.jskarel.KarelWorld;
import edu.stanford.cs.jskarel.KarelWorldMonitor;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class KarelWorldView
extends JSCanvas
implements ChangeListener,
ComponentListener,
MouseListener,
MouseMotionListener {
    private KarelWorld world;
    private KarelWorldMonitor monitor;
    private boolean displayOneFlag;
    private boolean numberSquaresFlag;
    private int look;
    private int nCols;
    private int nRows;
    private int sqSize;
    private int x0;
    private int y0;

    public KarelWorldView(KarelWorld world) {
        this.world = world;
        this.setBackground(KC.APPLICATION_BACKGROUND);
        this.look = 0;
        this.numberSquaresFlag = true;
        this.displayOneFlag = false;
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.monitor = null;
    }

    public KarelWorld getWorld() {
        return this.world;
    }

    public void setWorldMonitor(KarelWorldMonitor monitor) {
        this.monitor = monitor;
    }

    public void setDisplayParameters() {
        this.nRows = this.world.getNRows();
        this.nCols = this.world.getNCols();
        int width = this.getSize().width - (this.numberSquaresFlag ? 16 : 2);
        int height = this.getSize().height - (this.numberSquaresFlag ? 15 : 0) - 2;
        this.sqSize = Math.min(width / this.nCols, height / this.nRows);
        width = this.nCols * this.sqSize;
        height = this.nRows * this.sqSize;
        this.x0 = this.numberSquaresFlag ? 16 : 2;
        this.y0 = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        KarelWorld karelWorld = this.world;
        synchronized (karelWorld) {
            this.setDisplayParameters();
            this.paintOutline(g);
            this.paintCorners(g);
            this.paintWalls(g);
            this.paintBeepers(g);
            this.paintKarel(g);
        }
    }

    public void setLook(int look) {
        this.look = look;
    }

    public int getLook() {
        return this.look;
    }

    public void setNumberSquaresFlag(boolean flag) {
        this.numberSquaresFlag = flag;
    }

    public boolean getNumberSquaresFlag() {
        return this.numberSquaresFlag;
    }

    public void setDisplayOneFlag(boolean flag) {
        this.displayOneFlag = flag;
    }

    public boolean getDisplayOneFlag() {
        return this.displayOneFlag;
    }

    public void drawKarel(Graphics g, int x, int y, int sqSize, int dir) {
        if (sqSize < 20 || this.look == 0) {
            int karelSize = (int)Math.round((double)sqSize * 0.5);
            KarelGraphics.drawSimpleKarel(g, x, y, karelSize, dir, null);
        } else {
            int karelSize = sqSize - 7;
            KarelGraphics.drawFancyKarel(g, x, y, karelSize, dir, null);
        }
    }

    public Point getClickCorner(int mx, int my) {
        double sx = (double)(mx - this.x0 + this.sqSize / 2) / (double)this.sqSize;
        double sy = (double)(this.y0 + this.nRows * this.sqSize - my + this.sqSize / 2) / (double)this.sqSize;
        int tx = (int)(sx + 0.5);
        int ty = (int)(sy + 0.5);
        if (tx < 1 || tx > this.nCols || ty < 1 || ty > this.nRows) {
            return null;
        }
        if (Math.abs(sx - (double)tx) > 0.3 || Math.abs(sy - (double)ty) > 0.3) {
            return null;
        }
        return new Point(tx, ty);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.repaint();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.setDisplayParameters();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.monitor != null) {
            Point pt = this.getClickCorner(e.getX(), e.getY());
            if (pt == null) {
                this.checkForWallClick(e.getX(), e.getY());
            } else {
                Karel karel = this.world.getKarel();
                Point kpt = karel.getLocation();
                if (kpt.x == pt.x && kpt.y == pt.y) {
                    this.monitor.setActiveKarel(karel);
                } else {
                    this.monitor.setActiveKarel(null);
                }
                this.monitor.cornerAction(pt.x, pt.y);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.monitor != null) {
            this.monitor.setActiveKarel(null);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.monitor != null) {
            Point pt = this.getClickCorner(e.getX(), e.getY());
            if (pt == null) {
                this.checkForWallClick(e.getX(), e.getY());
            } else {
                this.monitor.cornerAction(pt.x, pt.y);
            }
        }
    }

    private void paintOutline(Graphics g) {
        g.setColor(Color.WHITE);
        g.fillRect(this.x0, this.y0, this.nCols * this.sqSize, this.nRows * this.sqSize);
        g.setColor(Color.BLACK);
        if (this.sqSize > 15 && this.numberSquaresFlag) {
            String label;
            g.setFont(KC.NUMBER_FONT);
            FontMetrics fm = g.getFontMetrics();
            int x = this.x0 + this.sqSize / 2;
            int y = this.y0 + this.nRows * this.sqSize + fm.getAscent() + 2;
            int ix = 1;
            while (ix <= this.nCols) {
                label = "" + ix;
                g.drawString(label, x - fm.stringWidth(label) / 2, y);
                x += this.sqSize;
                ++ix;
            }
            x = this.x0 - 2;
            y = this.y0 + this.nRows * this.sqSize - this.sqSize / 2 + 2;
            int iy = 1;
            while (iy <= this.nRows) {
                label = "" + iy;
                g.drawString(label, x - fm.stringWidth(label), y);
                y -= this.sqSize;
                ++iy;
            }
        }
    }

    private void paintCorners(Graphics g) {
        Color saveColor = g.getColor();
        int x = 1;
        while (x <= this.nCols) {
            int xc = Math.round(this.x0 + (x - 1) * this.sqSize);
            int y = 1;
            while (y <= this.nRows) {
                int yc = Math.round(this.y0 + (this.nRows - y) * this.sqSize);
                Color color = this.world.getCornerColor(x, y);
                if (color != null) {
                    g.setColor(color);
                    g.fillRect(xc, yc, this.sqSize, this.sqSize);
                }
                ++y;
            }
            ++x;
        }
        g.setColor(saveColor);
    }

    private void paintWalls(Graphics g) {
        int tick = (int)Math.round(0.2 * (double)this.sqSize);
        int x = 1;
        while (x <= this.nCols) {
            int kx = this.x0 + x * this.sqSize;
            int xc = kx - this.sqSize / 2;
            int y = 1;
            while (y <= this.nRows) {
                boolean here;
                int ky = this.y0 + (this.nRows - y) * this.sqSize;
                int yc = ky + this.sqSize / 2;
                Point pt = this.world.getKarel().getLocation();
                boolean bl = here = pt.x == x && pt.y == y;
                if (!here && this.world.getCornerColor(x, y) == null) {
                    g.drawLine(xc - tick / 2, yc, xc + tick / 2, yc);
                    g.drawLine(xc, yc - tick / 2, xc, yc + tick / 2);
                }
                if (x == 1 && this.world.checkWall(x, y, 3)) {
                    KarelGraphics.drawVerticalWall(g, kx - this.sqSize, ky, this.sqSize);
                }
                if (this.world.checkWall(x, y, 1)) {
                    KarelGraphics.drawVerticalWall(g, kx, ky, this.sqSize);
                }
                if (y == 1 && this.world.checkWall(x, y, 2)) {
                    KarelGraphics.drawHorizontalWall(g, kx - this.sqSize, ky + this.sqSize, this.sqSize);
                }
                if (this.world.checkWall(x, y, 0)) {
                    KarelGraphics.drawHorizontalWall(g, kx - this.sqSize, ky, this.sqSize);
                }
                ++y;
            }
            ++x;
        }
    }

    private void paintBeepers(Graphics g) {
        int x = 1;
        while (x <= this.nCols) {
            int xc = (int)Math.round((double)this.x0 + ((double)x - 0.5) * (double)this.sqSize);
            int y = 1;
            while (y <= this.nRows) {
                int yc = (int)Math.round((double)this.y0 + ((double)(this.nRows - y) + 0.5) * (double)this.sqSize);
                int nBeepers = this.world.getBeepersOnCorner(x, y);
                if (nBeepers > 0) {
                    String label = "" + nBeepers;
                    if (nBeepers == 1 && !this.displayOneFlag) {
                        label = "";
                    }
                    if (nBeepers == 99999999) {
                        label = "\u221e";
                    }
                    int beeperSize = (int)Math.round((double)this.sqSize * 0.7);
                    KarelGraphics.drawBeeper(g, xc, yc, beeperSize, null, label);
                }
                ++y;
            }
            ++x;
        }
    }

    private void paintKarel(Graphics g) {
        Karel karel = this.world.getKarel();
        Point pt = karel.getLocation();
        int xc = (int)Math.round((double)this.x0 + ((double)pt.x - 0.5) * (double)this.sqSize);
        int yc = (int)Math.round((double)this.y0 + ((double)(this.nRows - pt.y) + 0.5) * (double)this.sqSize);
        this.drawKarel(g, xc, yc, this.sqSize, karel.getDirection());
    }

    private void checkForWallClick(int mx, int my) {
        double sx = ((double)(mx - this.x0) + 0.5 * (double)this.sqSize) / (double)this.sqSize;
        double sy = (double)(this.y0 + this.nRows * this.sqSize - my + this.sqSize / 2) / (double)this.sqSize;
        int tx = (int)(sx + 0.5);
        int ty = (int)(sy + 0.5);
        if (Math.abs(sx - (double)tx) > 0.15 && Math.abs(sy - (double)ty) < 0.3) {
            if ((double)tx > sx) {
                --tx;
            }
            if (tx < 0 || tx > this.nCols || ty < 1 || ty > this.nRows) {
                return;
            }
            this.monitor.wallAction(tx, ty, 1);
        } else if (Math.abs(sy - (double)ty) > 0.15 && Math.abs(sx - (double)tx) < 0.3) {
            if ((double)ty > sy) {
                --ty;
            }
            if (tx < 1 || tx > this.nCols || ty < 0 || ty > this.nRows) {
                return;
            }
            this.monitor.wallAction(tx, ty, 0);
        }
    }
}

