/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.jskarel;

import edu.stanford.cs.jskarel.KC;
import edu.stanford.cs.jskarel.KarelWorldEditor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;

abstract class MapTool {
    private int x;
    private int y;
    private int width;
    private int height;

    public MapTool(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public boolean contains(int x, int y) {
        return x >= this.x && x < this.x + this.width && y >= this.y && y < this.y + this.height;
    }

    public abstract void paint(Graphics var1, KarelWorldEditor var2);

    public void toolAction(KarelWorldEditor editor) {
        editor.setSelectedTool(this);
    }

    public void wallAction(KarelWorldEditor editor, int x, int y, int dir) {
    }

    public void cornerAction(KarelWorldEditor editor, int x, int y) {
    }

    public void beeperBagAction(KarelWorldEditor editor) {
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setBorderGraphics(Graphics2D g2, boolean isSelected) {
        if (isSelected) {
            g2.setStroke(new BasicStroke(2.0f));
            g2.setColor(KC.SELECTED_BORDER_COLOR);
        } else {
            g2.setStroke(new BasicStroke(1.0f));
            g2.setColor(Color.BLACK);
        }
    }
}

