/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.jskarel;

import edu.stanford.cs.jskarel.KarelWorldEditor;
import edu.stanford.cs.jskarel.MapTool;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;

class SaveTool
extends MapTool {
    private boolean saveFlag;

    public SaveTool(int x, int y, boolean saveFlag) {
        super(x, y, 20, 20);
        this.saveFlag = saveFlag;
    }

    @Override
    public void paint(Graphics g, KarelWorldEditor editor) {
        Graphics2D g2 = (Graphics2D)g.create();
        Rectangle r = this.getBounds();
        g2.setColor(Color.WHITE);
        g2.fillRect(r.x, r.y, 20, 20);
        this.setBorderGraphics(g2, false);
        g2.drawRect(r.x, r.y, 20, 20);
        int ds = 14;
        int xc = r.x + 10;
        int yc = r.y + 10;
        Polygon disk = new Polygon();
        disk.addPoint(xc - ds / 2, yc - ds / 2);
        disk.addPoint(xc + ds / 2 - 3, yc - ds / 2);
        disk.addPoint(xc + ds / 2, yc - ds / 2 + 3);
        disk.addPoint(xc + ds / 2, yc + ds / 2);
        disk.addPoint(xc - ds / 2, yc + ds / 2);
        disk.addPoint(xc - ds / 2, yc - ds / 2);
        g2.setColor(Color.LIGHT_GRAY);
        g2.fillPolygon(disk);
        g2.setColor(Color.BLACK);
        g2.setStroke(new BasicStroke(1.0f));
        g2.drawPolygon(disk);
        g2.setColor(Color.DARK_GRAY);
        g2.fillRect(xc - ds / 2 + 2, yc - ds / 2 + 1, 11, 6);
        g2.setColor(Color.WHITE);
        g2.fillRect(xc - ds / 2 + 9, yc - ds / 2 + 2, 2, 4);
        if (!this.saveFlag) {
            g2.setColor(Color.RED);
            g2.setStroke(new BasicStroke(3.0f));
            g2.drawLine(r.x + 5, r.y + 5, r.x + 15, r.y + 15);
            g2.drawLine(r.x + 5, r.y + 15, r.x + 15, r.y + 5);
        }
        g2.dispose();
    }

    @Override
    public void toolAction(KarelWorldEditor editor) {
        editor.getApplication().setEditWorldEnabled(false);
        if (this.saveFlag) {
            editor.getApplication().saveWorld();
        }
    }
}

