/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs.jskarel;

import edu.stanford.cs.jskarel.KarelWorld;
import edu.stanford.cs.jskarel.KarelWorldEditor;
import edu.stanford.cs.jskarel.MapTool;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;

class WallTool
extends MapTool {
    private boolean createWall;

    public WallTool(int x, int y, boolean createWall) {
        super(x, y, 20, 20);
        this.createWall = createWall;
    }

    @Override
    public void paint(Graphics g, KarelWorldEditor editor) {
        Graphics2D g2 = (Graphics2D)g.create();
        Rectangle r = this.getBounds();
        g2.setColor(Color.WHITE);
        g2.fillRect(r.x, r.y, 20, 20);
        this.setBorderGraphics(g2, editor.getSelectedTool() == this);
        g2.drawRect(r.x, r.y, 20, 20);
        g2.setColor(Color.BLACK);
        g2.setStroke(new BasicStroke(4.0f));
        g2.drawLine(r.x + 4, r.y + 10, r.x + 16, r.y + 10);
        if (!this.createWall) {
            g2.setColor(Color.RED);
            g2.setStroke(new BasicStroke(3.0f));
            g2.drawLine(r.x + 5, r.y + 5, r.x + 15, r.y + 15);
            g2.drawLine(r.x + 5, r.y + 15, r.x + 15, r.y + 5);
        }
        g2.dispose();
    }

    @Override
    public void wallAction(KarelWorldEditor editor, int x, int y, int dir) {
        KarelWorld world = editor.getWorld();
        if (this.createWall) {
            world.setWall(x, y, dir);
        } else {
            world.clearWall(x, y, dir);
        }
        editor.getView().repaint();
    }
}

